/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal.task;

import com.oracle.coherence.common.identifiers.Identifier;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class TaskProcessorMediatorKey
implements Serializable,
PortableObject,
ExternalizableLite {
    private Identifier taskProcessorDefinitionIdentifier;
    private int memberId;
    private UID uniqueId;

    public TaskProcessorMediatorKey() {
    }

    public TaskProcessorMediatorKey(Identifier definitionIdentifier, int memberId, UID uniqueId) {
        this.taskProcessorDefinitionIdentifier = definitionIdentifier;
        this.memberId = memberId;
        this.uniqueId = uniqueId;
    }

    public Identifier getTaskProcessorDefinitionIdentifier() {
        return this.taskProcessorDefinitionIdentifier;
    }

    public int getMemberId() {
        return this.memberId;
    }

    public UID getUniqueId() {
        return this.uniqueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.memberId;
        result = 31 * result + (this.taskProcessorDefinitionIdentifier == null ? 0 : this.taskProcessorDefinitionIdentifier.hashCode());
        result = 31 * result + (this.uniqueId == null ? 0 : this.uniqueId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskProcessorMediatorKey other = (TaskProcessorMediatorKey)obj;
        if (this.memberId != other.memberId) {
            return false;
        }
        if (this.taskProcessorDefinitionIdentifier == null ? other.taskProcessorDefinitionIdentifier != null : !this.taskProcessorDefinitionIdentifier.equals(other.taskProcessorDefinitionIdentifier)) {
            return false;
        }
        return !(this.uniqueId == null ? other.uniqueId != null : !this.uniqueId.equals((Object)other.uniqueId));
    }

    public String toString() {
        return "TPSK:{" + this.taskProcessorDefinitionIdentifier.toString() + "," + this.memberId + "," + this.uniqueId + "}";
    }

    public void readExternal(PofReader reader) throws IOException {
        this.taskProcessorDefinitionIdentifier = (Identifier)reader.readObject(0);
        this.memberId = reader.readInt(1);
        this.uniqueId = (UID)reader.readObject(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.taskProcessorDefinitionIdentifier);
        writer.writeInt(1, this.memberId);
        writer.writeObject(2, (Object)this.uniqueId);
    }

    public void readExternal(DataInput in) throws IOException {
        this.taskProcessorDefinitionIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
        this.memberId = in.readInt();
        this.uniqueId = (UID)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.taskProcessorDefinitionIdentifier);
        out.writeInt(this.memberId);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.uniqueId);
    }
}

