/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal.task;

import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.task.DefaultTaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorProxy;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorProxyMBean;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.Registry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskProcessorMBeanManager {
    private static Logger logger = Logger.getLogger(TaskProcessorMBeanManager.class.getName());
    private ConcurrentHashMap<TaskProcessorMediatorKey, TaskProcessorMediatorProxy> localMBeans = new ConcurrentHashMap();
    private volatile boolean shuttingDown = false;

    public TaskProcessorMBeanManager() {
        DefaultTaskProcessorMediator.setMBeanManager(this);
    }

    public void addMBean(TaskProcessorMediatorKey key) {
        TaskProcessorMediatorProxy proxy = new TaskProcessorMediatorProxy(key);
        this.localMBeans.put(key, proxy);
        this.registerMBean(key, proxy);
    }

    private void removeMBean(TaskProcessorMediatorKey key) {
        TaskProcessorMediatorProxy proxy = this.localMBeans.get(key);
        if (proxy != null) {
            this.unregisterMBean(proxy);
        }
    }

    public void updateMBean(Object key, TaskProcessorMediatorProxyMBean bean) {
        TaskProcessorMediatorProxy proxy = this.localMBeans.get(key);
        if (proxy != null) {
            proxy.setValue(bean);
        }
    }

    protected void registerMBean(TaskProcessorMediatorKey key, TaskProcessorMediatorProxy mBeanProxy) {
        Registry registry;
        if (!this.shuttingDown && (registry = CacheFactory.ensureCluster().getManagement()) != null) {
            mBeanProxy.setMBeanName(registry.ensureGlobalName(String.format("type=ProcessingPattern,subType=TaskProcessor,id=%s", key.getTaskProcessorDefinitionIdentifier().toString() + ":" + key.getMemberId() + ":" + CacheFactory.ensureCluster().getLocalMember().getId())));
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Registering JMX management extensions for TaskProcessorMediator {0}", mBeanProxy.getMBeanName());
            }
            registry.register(mBeanProxy.getMBeanName(), (Object)mBeanProxy);
        }
    }

    protected void unregisterMBean(TaskProcessorMediatorProxy mBeanProxy) {
        Registry registry;
        if (!this.shuttingDown && (registry = CacheFactory.ensureCluster().getManagement()) != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Unregistering JMX management extensions for TaskProcessorMediator %s", mBeanProxy.getMBeanName());
            }
            registry.unregister(mBeanProxy.getMBeanName());
        }
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void onDependenciesViolated(Environment environment) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Shutting down TaskProcessorMBeanManager.");
        }
        this.shuttingDown = true;
    }
}

