/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal.task;

import com.oracle.coherence.common.processors.InvokeMethodProcessor;
import com.oracle.coherence.patterns.processing.internal.SubmissionKeyPair;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoverTasks
implements Runnable {
    private static final Logger logger = Logger.getLogger(RecoverTasks.class.getName());
    private LinkedList<SubmissionKeyPair> tasks;
    private ConfigurableCacheFactory ccFactory;
    private NamedCache submissionResultCache;
    private NamedCache submissionCache;

    public RecoverTasks(LinkedList<SubmissionKeyPair> tasks) {
        this.tasks = tasks;
        this.ccFactory = CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(this.getClass().getClassLoader());
        this.submissionResultCache = this.ccFactory.ensureCache("coherence.patterns.processing.submissionresults", null);
        this.submissionCache = this.ccFactory.ensureCache("coherence.patterns.processing.submissions", null);
    }

    @Override
    public void run() {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Starting recovery of {0,number} tasks.", this.tasks.size());
        }
        for (SubmissionKeyPair keyPair : this.tasks) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Recovering {0}", keyPair);
            }
            this.submissionResultCache.invoke((Object)keyPair.getResultId(), (InvocableMap.EntryProcessor)new InvokeMethodProcessor("retry", new Object[0]));
            Object result = this.submissionCache.invoke((Object)keyPair.getKey(), (InvocableMap.EntryProcessor)new InvokeMethodProcessor("reDispatch", new Object[]{0L}));
            if (result != null) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Redispatched {0}", keyPair.getKey());
                continue;
            }
            if (!logger.isLoggable(Level.SEVERE)) continue;
            logger.log(Level.SEVERE, "Unable to redispatch {0}", keyPair.getKey());
        }
    }
}

