/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal.task;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.leasing.Lease;
import com.oracle.coherence.common.leasing.Leasing;
import com.oracle.coherence.common.util.ChangeIndication;
import com.oracle.coherence.patterns.processing.internal.SubmissionKey;
import com.oracle.coherence.patterns.processing.internal.SubmissionKeyPair;
import com.oracle.coherence.patterns.processing.internal.task.RecoverTasks;
import com.oracle.coherence.patterns.processing.internal.task.ServerLeaseMonitor;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMBeanManager;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorProxyMBean;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorStateEnum;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTaskProcessorMediator
implements ExternalizableLite,
PortableObject,
TaskProcessorMediator,
TaskProcessorMediatorProxyMBean,
ChangeIndication {
    private static TaskProcessorMBeanManager m_mgrMbean;
    private static ServerLeaseMonitor leaseMonitor;
    public static final String CACHENAME = "coherence.patterns.processing.taskprocessormediator";
    private static final Logger logger;
    private TaskProcessorMediatorKey taskProcessorKey;
    private LinkedList<SubmissionKeyPair> tasks;
    private LinkedList<SubmissionKeyPair> tasksInProgress;
    private int noAcceptedTasks;
    private int noExecutedTasks;
    private Lease taskProcessorLease;
    private TaskProcessorStateEnum stateEnum = TaskProcessorStateEnum.INACTIVE;
    private long totalTaskExecutionDuration;
    private long minimumTaskExecutionDuration = -1L;
    private long maximumTaskExecutionDuration;
    private long lastTaskExecutionDuration;
    private int yieldTaskCount;
    private Map attributeMap = new HashMap();
    private boolean changed;

    public DefaultTaskProcessorMediator() {
    }

    public DefaultTaskProcessorMediator(TaskProcessorMediatorKey taskProcessorKey) {
        this();
        this.taskProcessorKey = taskProcessorKey;
        this.initialize();
    }

    public DefaultTaskProcessorMediator(TaskProcessorMediatorKey taskProcessorKey, Map map) {
        this();
        this.taskProcessorKey = taskProcessorKey;
        this.attributeMap.putAll(map);
        this.initialize();
    }

    public static void setMBeanManager(TaskProcessorMBeanManager mgr) {
        m_mgrMbean = mgr;
    }

    public static void setLeaseMonitor(ServerLeaseMonitor leaseMonitor) {
        DefaultTaskProcessorMediator.leaseMonitor = leaseMonitor;
    }

    @Override
    public SubmissionKeyPair dequeueTask() {
        if (this.stateEnum == TaskProcessorStateEnum.ACTIVE) {
            SubmissionKeyPair taskInProgress;
            if (this.tasks == null) {
                this.initialize();
            }
            if ((taskInProgress = this.tasks.poll()) != null) {
                this.tasksInProgress.add(taskInProgress);
                this.setChanged();
            }
            return taskInProgress;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Rejecting DequeueTask because TaskProcessor is INACTIVE");
        }
        return null;
    }

    @Override
    public List<SubmissionKeyPair> drainQueueToBeExecuted() {
        if (this.stateEnum == TaskProcessorStateEnum.ACTIVE) {
            if (this.tasks == null) {
                this.initialize();
            }
            LinkedList<SubmissionKeyPair> result = new LinkedList<SubmissionKeyPair>();
            for (SubmissionKeyPair tp : this.tasks) {
                result.add(tp);
                this.tasksInProgress.add(tp);
            }
            this.tasks.clear();
            this.setChanged();
            return result;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Rejecting DequeueTask because TaskProcessor is INACTIVE");
        }
        return null;
    }

    @Override
    public void enqueueTask(SubmissionKey taskId, Identifier resultid) {
        SubmissionKeyPair keyPair;
        if (this.tasks == null) {
            this.initialize();
        }
        if (!this.tasks.contains(keyPair = new SubmissionKeyPair(taskId, resultid))) {
            this.tasks.add(keyPair);
            ++this.noAcceptedTasks;
            this.setChanged();
        }
    }

    @Override
    public TaskProcessorMediatorKey getTaskProcessorKey() {
        return this.taskProcessorKey;
    }

    @Override
    public int numberOfTasksInProgress() {
        return this.tasksInProgress == null ? 0 : this.tasksInProgress.size();
    }

    @Override
    public List<SubmissionKeyPair> getTasksInProgress() {
        return this.tasksInProgress;
    }

    @Override
    public int size() {
        return this.tasks == null ? 0 : this.tasks.size();
    }

    @Override
    public void taskDone(SubmissionKey oSubmissionKey, long executiontime, boolean yield) {
        for (SubmissionKeyPair tp : this.tasksInProgress) {
            if (!tp.getKey().equals(oSubmissionKey)) continue;
            this.tasksInProgress.remove(tp);
            break;
        }
        for (SubmissionKeyPair tp : this.tasks) {
            if (!tp.getKey().equals(oSubmissionKey)) continue;
            this.tasks.remove(tp);
            break;
        }
        ++this.noExecutedTasks;
        if (yield) {
            ++this.yieldTaskCount;
        }
        this.updateExecutionTiming(executiontime);
        this.setChanged();
    }

    private void updateExecutionTiming(long executionDuration) {
        this.totalTaskExecutionDuration += executionDuration;
        if (this.minimumTaskExecutionDuration == -1L) {
            this.minimumTaskExecutionDuration = executionDuration;
        } else if (this.minimumTaskExecutionDuration > executionDuration) {
            this.minimumTaskExecutionDuration = executionDuration;
        }
        if (executionDuration > this.maximumTaskExecutionDuration) {
            this.maximumTaskExecutionDuration = executionDuration;
        }
        this.lastTaskExecutionDuration = executionDuration;
        this.setChanged();
    }

    public String toString() {
        return "DefaultTaskProcessorMediator [" + (this.attributeMap != null ? "attributeMap=" + this.attributeMap + ", " : "") + "lastTaskExecutionDuration=" + this.lastTaskExecutionDuration + ", maximumTaskExecutionDuration=" + this.maximumTaskExecutionDuration + ", minimumTaskExecutionDuration=" + this.minimumTaskExecutionDuration + ", noAcceptedTasks=" + this.noAcceptedTasks + ", noExecutedTasks=" + this.noExecutedTasks + ", " + (this.stateEnum != null ? "stateEnum=" + (Object)((Object)this.stateEnum) + ", " : "") + (this.taskProcessorKey != null ? "taskProcessorKey=" + this.taskProcessorKey + ", " : "") + (this.taskProcessorLease != null ? "taskProcessorLease=" + this.taskProcessorLease + ", " : "") + (this.tasks != null ? "tasks=" + this.tasks + ", " : "") + (this.tasksInProgress != null ? "tasksInProgress=" + this.tasksInProgress + ", " : "") + "totalTaskExecutionDuration=" + this.totalTaskExecutionDuration + ", yieldTaskCount=" + this.yieldTaskCount + "]";
    }

    private void initialize() {
        this.tasks = new LinkedList();
        this.tasksInProgress = new LinkedList();
    }

    @Override
    public boolean offerTask(SubmissionKey submissionKey, Identifier resultid) {
        if (this.stateEnum == TaskProcessorStateEnum.ACTIVE) {
            if (this.tasks == null) {
                this.initialize();
            }
            this.enqueueTask(submissionKey, resultid);
            return true;
        }
        return false;
    }

    @Override
    public String getKey() {
        return this.taskProcessorKey.toString();
    }

    @Override
    public int getAcceptedTaskCount() {
        return this.noAcceptedTasks;
    }

    @Override
    public int getExecutedTaskCount() {
        return this.noExecutedTasks;
    }

    @Override
    public int getYieldTaskCount() {
        return this.yieldTaskCount;
    }

    @Override
    public String getIdsOfCurrentlyExecutingTask() {
        StringBuilder sResult = new StringBuilder("No task executing");
        if (this.tasksInProgress != null && this.tasksInProgress.size() > 0) {
            sResult.setLength(0);
            sResult.append(" InProgress:");
            for (SubmissionKeyPair tp : this.tasksInProgress) {
                sResult.append(tp.toString());
                sResult.append(" ");
            }
        }
        return sResult.toString();
    }

    @Override
    public double getAverageTaskExecutionDuration() {
        if (this.noExecutedTasks > 0) {
            return (double)this.totalTaskExecutionDuration / (double)this.noExecutedTasks;
        }
        return 0.0;
    }

    @Override
    public long getLastTaskExecutionDuration() {
        return this.lastTaskExecutionDuration;
    }

    @Override
    public long getMaximumTaskExecutionDuration() {
        return this.maximumTaskExecutionDuration;
    }

    @Override
    public long getMinimumTaskExecutionDuration() {
        return this.minimumTaskExecutionDuration;
    }

    @Override
    public long getTotalTaskExecutionDuration() {
        return this.totalTaskExecutionDuration;
    }

    @Override
    public boolean extendTaskProcessorLease(long duration) {
        if (this.stateEnum == TaskProcessorStateEnum.ACTIVE) {
            boolean result = this.taskProcessorLease.extend(duration);
            leaseMonitor.registerLease(this.taskProcessorKey, this.taskProcessorLease);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Lease {0} extended with {1} ms for TaskProcessor {2}", new Object[]{this.taskProcessorLease, duration, this});
            }
            this.setChanged();
            return result;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Trying to extend lease for TaskProcessor {0} but it is INACTIVE", this);
        }
        return false;
    }

    @Override
    public Lease getTaskProcessorLease(long duration) {
        this.taskProcessorLease = Leasing.newLease((long)duration);
        this.stateEnum = TaskProcessorStateEnum.ACTIVE;
        leaseMonitor.registerLease(this.taskProcessorKey, this.taskProcessorLease);
        this.setChanged();
        return this.taskProcessorLease;
    }

    @Override
    public void leaseExpired(Lease lease) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Lease {0} expired for TaskProcessor {1} setting to INACTIVE", new Object[]{lease, this});
        }
        this.stateEnum = TaskProcessorStateEnum.INACTIVE;
        this.recoverTasks();
        this.setChanged();
    }

    private void recoverTasks() {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Recovering tasks {0}", this.tasks);
        }
        LinkedList mergedlist = (LinkedList)this.tasks.clone();
        mergedlist.addAll(this.tasksInProgress);
        RecoverTasks task = new RecoverTasks(mergedlist);
        Thread recoverthread = new Thread(task);
        recoverthread.start();
        this.tasks.clear();
        this.tasksInProgress.clear();
        this.setChanged();
    }

    @Override
    public void entryArrived() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "TaskProcessorMediator {0} arrived to this member.", this);
        }
        if (this.taskProcessorLease != null && this.stateEnum == TaskProcessorStateEnum.ACTIVE) {
            leaseMonitor.registerLease(this.getTaskProcessorKey(), this.taskProcessorLease);
        }
    }

    @Override
    public void entryDeparted() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "TaskProcessorMediator {0} departed from this member.", this);
        }
        if (this.taskProcessorLease != null) {
            leaseMonitor.deregisterLease(this.getTaskProcessorKey());
        }
    }

    @Override
    public TaskProcessorStateEnum getProcessorState() {
        return this.stateEnum;
    }

    @Override
    public Map getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    public void setAttribute(Object key, Object value) {
        this.attributeMap.put(key, value);
        this.setChanged();
    }

    private void setChanged() {
        this.changed = true;
    }

    public void beforeChange() {
        this.changed = false;
    }

    public boolean changed() {
        return this.changed;
    }

    public void onInserted(BinaryEntry entry) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, " insert was received for TaskProcessorMediator", this);
        }
        if (!m_mgrMbean.isShuttingDown()) {
            m_mgrMbean.addMBean((TaskProcessorMediatorKey)entry.getKey());
        }
    }

    public void onUpdated(BinaryEntry entry) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, " update was received for TaskProcessorMediator", this);
        }
        if (!m_mgrMbean.isShuttingDown()) {
            m_mgrMbean.updateMBean(entry.getKey(), this);
        }
    }

    public void onRemoved(BinaryEntry entry) {
    }

    public void onArrived(BinaryEntry entry) {
        this.entryArrived();
        this.onInserted(entry);
    }

    public void onDeparted(BinaryEntry entry) {
        this.entryDeparted();
        this.onRemoved(entry);
    }

    public void readExternal(DataInput in) throws IOException {
        this.taskProcessorKey = (TaskProcessorMediatorKey)ExternalizableHelper.readObject((DataInput)in);
        this.tasks = (LinkedList)ExternalizableHelper.readObject((DataInput)in);
        this.tasksInProgress = (LinkedList)ExternalizableHelper.readObject((DataInput)in);
        this.noAcceptedTasks = in.readInt();
        this.noExecutedTasks = in.readInt();
        this.stateEnum = TaskProcessorStateEnum.valueOf(in.readUTF());
        this.taskProcessorLease = (Lease)ExternalizableHelper.readObject((DataInput)in);
        this.totalTaskExecutionDuration = in.readLong();
        this.minimumTaskExecutionDuration = in.readLong();
        this.maximumTaskExecutionDuration = in.readLong();
        this.lastTaskExecutionDuration = in.readLong();
        this.yieldTaskCount = in.readInt();
        this.attributeMap = new HashMap();
        ExternalizableHelper.readMap((DataInput)in, (Map)this.attributeMap, (ClassLoader)this.getClass().getClassLoader());
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.taskProcessorKey);
        ExternalizableHelper.writeObject((DataOutput)out, this.tasks);
        ExternalizableHelper.writeObject((DataOutput)out, this.tasksInProgress);
        out.writeInt(this.noAcceptedTasks);
        out.writeInt(this.noExecutedTasks);
        out.writeUTF(this.stateEnum.name());
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.taskProcessorLease);
        out.writeLong(this.totalTaskExecutionDuration);
        out.writeLong(this.minimumTaskExecutionDuration);
        out.writeLong(this.maximumTaskExecutionDuration);
        out.writeLong(this.lastTaskExecutionDuration);
        out.writeInt(this.yieldTaskCount);
        ExternalizableHelper.writeMap((DataOutput)out, (Map)this.attributeMap);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.taskProcessorKey = (TaskProcessorMediatorKey)reader.readObject(0);
        this.tasks = new LinkedList();
        reader.readCollection(1, this.tasks);
        this.tasksInProgress = new LinkedList();
        reader.readCollection(2, this.tasksInProgress);
        this.noAcceptedTasks = reader.readInt(3);
        this.noExecutedTasks = reader.readInt(4);
        this.stateEnum = TaskProcessorStateEnum.valueOf(reader.readString(5));
        this.taskProcessorLease = (Lease)reader.readObject(6);
        this.totalTaskExecutionDuration = reader.readLong(7);
        this.minimumTaskExecutionDuration = reader.readLong(8);
        this.maximumTaskExecutionDuration = reader.readLong(9);
        this.lastTaskExecutionDuration = reader.readLong(10);
        this.yieldTaskCount = reader.readInt(11);
        this.attributeMap = new HashMap();
        reader.readMap(12, this.attributeMap);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.taskProcessorKey);
        writer.writeCollection(1, this.tasks);
        writer.writeCollection(2, this.tasksInProgress);
        writer.writeInt(3, this.noAcceptedTasks);
        writer.writeInt(4, this.noExecutedTasks);
        writer.writeString(5, this.stateEnum.name());
        writer.writeObject(6, (Object)this.taskProcessorLease);
        writer.writeLong(7, this.totalTaskExecutionDuration);
        writer.writeLong(8, this.minimumTaskExecutionDuration);
        writer.writeLong(9, this.maximumTaskExecutionDuration);
        writer.writeLong(10, this.lastTaskExecutionDuration);
        writer.writeInt(11, this.yieldTaskCount);
        writer.writeMap(12, this.attributeMap);
    }

    static {
        logger = Logger.getLogger(DefaultTaskProcessorMediator.class.getName());
    }
}

