/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal.task;

import com.oracle.coherence.common.util.ObjectProxyFactory;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.Submission;
import com.oracle.coherence.patterns.processing.internal.SubmissionResult;
import com.oracle.coherence.patterns.processing.internal.task.DefaultTaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorDefinitionManager;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.oracle.coherence.patterns.processing.task.TaskProcessorType;
import com.oracle.coherence.patterns.processing.taskprocessor.ClientLeaseMaintainer;
import com.tangosol.io.pof.PortableException;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UID;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalPut;
import com.tangosol.util.processor.ConditionalRemove;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTaskProcessorDefinitionManager
implements TaskProcessorDefinitionManager {
    private static Logger logger = Logger.getLogger(DefaultTaskProcessorDefinitionManager.class.getName());
    private NamedCache taskProcessorDefinitionCache;
    private final ConfigurableCacheFactory configurableCacheFactory;
    private Environment environment;
    private volatile boolean started;
    private LinkedList<TaskProcessorDefinition> tobeRegistered;

    public DefaultTaskProcessorDefinitionManager(Environment environment, ConfigurableCacheFactory configurableCacheFactory) {
        this.configurableCacheFactory = configurableCacheFactory;
        this.tobeRegistered = new LinkedList();
        this.environment = environment;
    }

    @Override
    public void registerTaskProcessor(TaskProcessorDefinition definition) throws Throwable {
        if (!this.started) {
            this.tobeRegistered.add(definition);
        } else {
            this.storeTaskProcessorDefinition(definition);
        }
    }

    private void storeTaskProcessorDefinition(TaskProcessorDefinition definition) throws Throwable {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Storing TaskProcessorDefinition {0}", definition);
        }
        NotFilter filter = new NotFilter((Filter)PresentFilter.INSTANCE);
        this.taskProcessorDefinitionCache.invoke((Object)definition.getIdentifier(), (InvocableMap.EntryProcessor)new ConditionalPut((Filter)filter, (Object)definition));
        if (definition.getTaskProcessorType() == TaskProcessorType.SINGLE) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Starting SINGLE TaskProcessor for definition {0}", definition);
            }
            ObjectProxyFactory submissionProxyFactory = (ObjectProxyFactory)this.environment.getResource(Submission.class);
            ObjectProxyFactory submissionResultProxyFactory = (ObjectProxyFactory)this.environment.getResource(SubmissionResult.class);
            ObjectProxyFactory taskProcessorMediatorProxyFactory = (ObjectProxyFactory)this.environment.getResource(TaskProcessorMediator.class);
            ClientLeaseMaintainer clientLeaseMaintainer = this.environment.getResource(ClientLeaseMaintainer.class);
            TaskProcessorMediatorKey key = new TaskProcessorMediatorKey(definition.getIdentifier(), 0, new UID());
            try {
                TaskProcessorMediator tps = (TaskProcessorMediator)taskProcessorMediatorProxyFactory.createRemoteObjectIfNotExists((Object)key, DefaultTaskProcessorMediator.class, new Object[]{key, definition.getAttributeMap()});
                CacheService cs = taskProcessorMediatorProxyFactory.getNamedCache().getCacheService();
                if (cs instanceof DistributedCacheService) {
                    tps.setAttribute("machinename", CacheFactory.ensureCluster().getLocalMember().getMachineName());
                    tps.setAttribute("hostname", CacheFactory.ensureCluster().getLocalMember().getAddress().getHostName());
                    tps.setAttribute("rackname", CacheFactory.ensureCluster().getLocalMember().getRackName());
                    tps.setAttribute("membername", CacheFactory.ensureCluster().getLocalMember().getMemberName());
                    tps.setAttribute("processname", CacheFactory.ensureCluster().getLocalMember().getProcessName());
                    tps.setAttribute("rolename", CacheFactory.ensureCluster().getLocalMember().getRoleName());
                    tps.setAttribute("taskprocessortype", "single");
                }
                definition.getTaskProcessor().onStartup(tps, key, (ObjectProxyFactory<Submission>)submissionProxyFactory, (ObjectProxyFactory<SubmissionResult>)submissionResultProxyFactory, (ObjectProxyFactory<TaskProcessorMediator>)taskProcessorMediatorProxyFactory, clientLeaseMaintainer);
            }
            catch (PortableException e) {
                if (e.getName().equals("Portable(java.lang.IllegalStateException)")) {
                    logger.log(Level.SEVERE, "A TaskProcessor with the ID {0} already exists (SINGLE)", definition.getIdentifier());
                    throw new RuntimeException(e);
                }
                logger.log(Level.SEVERE, "A TaskProcessor with the ID {0} wasn't possible to create due to exception {1}", new Object[]{definition.getIdentifier(), e});
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void unregisterTaskProcessor(TaskProcessorDefinition definition) {
        this.taskProcessorDefinitionCache.invoke((Object)definition.getIdentifier(), (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)PresentFilter.INSTANCE));
    }

    public void onDependenciesSatisfied(Environment environment) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "DefaultTask Processor Definition Manager starting");
        }
        this.taskProcessorDefinitionCache = this.configurableCacheFactory.ensureCache("coherence.patterns.processing.taskprocessordefinitions", null);
        Iterator iter = this.tobeRegistered.iterator();
        while (iter.hasNext()) {
            try {
                this.storeTaskProcessorDefinition((TaskProcessorDefinition)iter.next());
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Could not store TaskProcessorDefinition", e);
            }
        }
        this.started = true;
    }

    public void onDependenciesViolated(Environment environment) {
        this.taskProcessorDefinitionCache = null;
    }
}

