/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal.task;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.processing.task.TaskProcessor;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.oracle.coherence.patterns.processing.task.TaskProcessorType;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultTaskProcessorDefinition
implements TaskProcessorDefinition,
Serializable,
PortableObject,
ExternalizableLite {
    public static final String CACHENAME = "coherence.patterns.processing.taskprocessordefinitions";
    private Identifier identifier;
    private String name;
    private TaskProcessorType taskProcessorType;
    private TaskProcessor taskProcessor;
    private Map<String, String> attributeMap;

    public DefaultTaskProcessorDefinition() {
    }

    public DefaultTaskProcessorDefinition(Identifier identifier, String name, TaskProcessorType taskProcessorType, TaskProcessor taskProcessor, Map<String, String> attributeMap) {
        this.identifier = identifier;
        this.name = name;
        this.taskProcessorType = taskProcessorType;
        this.taskProcessor = taskProcessor;
        this.attributeMap = attributeMap;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TaskProcessorType getTaskProcessorType() {
        return this.taskProcessorType;
    }

    @Override
    public TaskProcessor getTaskProcessor() {
        return this.taskProcessor;
    }

    @Override
    public Map<String, String> getAttributeMap() {
        return this.attributeMap;
    }

    public String toString() {
        return "TPD:{" + this.identifier.toString() + "," + this.name + "," + this.taskProcessorType.toString() + "}";
    }

    public void readExternal(PofReader reader) throws IOException {
        this.identifier = (Identifier)reader.readObject(0);
        this.name = reader.readString(1);
        this.taskProcessorType = TaskProcessorType.valueOf(reader.readString(2));
        this.taskProcessor = (TaskProcessor)reader.readObject(3);
        this.attributeMap = new HashMap<String, String>();
        reader.readMap(4, this.attributeMap);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.identifier);
        writer.writeString(1, this.name);
        writer.writeString(2, this.taskProcessorType.name());
        writer.writeObject(3, (Object)this.taskProcessor);
        writer.writeMap(4, this.attributeMap);
    }

    public void readExternal(DataInput in) throws IOException {
        this.identifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
        this.name = in.readUTF();
        this.taskProcessorType = TaskProcessorType.valueOf(in.readUTF());
        this.taskProcessor = (TaskProcessor)ExternalizableHelper.readObject((DataInput)in);
        this.attributeMap = new HashMap<String, String>();
        ExternalizableHelper.readMap((DataInput)in, this.attributeMap, (ClassLoader)this.getClass().getClassLoader());
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.identifier);
        out.writeUTF(this.name);
        out.writeUTF(this.taskProcessorType.name());
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.taskProcessor);
        ExternalizableHelper.writeMap((DataOutput)out, this.attributeMap);
    }
}

