/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal.task;

import com.oracle.coherence.common.leasing.Lease;
import com.oracle.coherence.common.processors.InvokeMethodProcessor;
import com.oracle.coherence.common.threading.ExecutorServiceFactory;
import com.oracle.coherence.common.threading.ThreadFactories;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.task.DefaultTaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.ServerLeaseMonitor;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultServerLeaseMonitor
implements ServerLeaseMonitor {
    private static final Logger logger = Logger.getLogger(DefaultServerLeaseMonitor.class.getName());
    private ScheduledExecutorService executorService;
    private ConcurrentHashMap<TaskProcessorMediatorKey, Lease> leases;
    private NamedCache taskProcessorMediatorCache;
    private long leaseValidityCheckingDelay;
    private Environment environment;

    public DefaultServerLeaseMonitor(Environment environment, long leaseValidityCheckingDelay) {
        DefaultTaskProcessorMediator.setLeaseMonitor(this);
        this.environment = environment;
        this.executorService = ExecutorServiceFactory.newSingleThreadScheduledExecutor((ThreadFactory)ThreadFactories.newThreadFactory((boolean)true, (String)"ServerLeaseMonitor", null));
        this.leases = new ConcurrentHashMap();
        this.leaseValidityCheckingDelay = leaseValidityCheckingDelay;
    }

    @Override
    public void registerLease(TaskProcessorMediatorKey leaseOwner, Lease lease) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINEST, "Registering Lease for TaskProcessor {0}. Lease is {1}.", new Object[]{leaseOwner, lease});
        }
        this.leases.put(leaseOwner, lease);
    }

    @Override
    public void deregisterLease(TaskProcessorMediatorKey leaseOwner) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "De-Registering Lease for TaskProcessor {0}.", new Object[]{leaseOwner});
        }
        this.leases.remove(leaseOwner);
    }

    public void onDependenciesSatisfied(Environment environment) {
        this.taskProcessorMediatorCache = CacheFactory.getCache((String)"coherence.patterns.processing.taskprocessormediator");
        this.executorService.scheduleAtFixedRate(new LeaseValidator(), this.leaseValidityCheckingDelay, this.leaseValidityCheckingDelay, TimeUnit.MILLISECONDS);
    }

    private class LeaseValidator
    implements Runnable {
        private LeaseValidator() {
        }

        @Override
        public void run() {
            block8: {
                try {
                    long currentTime = System.currentTimeMillis();
                    LinkedList<TaskProcessorMediatorKey> expiredLeaseOwners = null;
                    for (TaskProcessorMediatorKey leaseOwner : DefaultServerLeaseMonitor.this.leases.keySet()) {
                        Lease lease = (Lease)DefaultServerLeaseMonitor.this.leases.get(leaseOwner);
                        boolean deregisterLease = false;
                        if (!lease.isValidAt(currentTime)) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.log(Level.WARNING, "Lease for TaskProcessor {0} has expired. Lease is {1}. Removing TaskProcessor.", new Object[]{leaseOwner, lease});
                            }
                            DefaultServerLeaseMonitor.this.taskProcessorMediatorCache.invoke((Object)leaseOwner, (InvocableMap.EntryProcessor)new InvokeMethodProcessor("leaseExpired", new Object[]{lease}));
                            DefaultServerLeaseMonitor.this.taskProcessorMediatorCache.remove((Object)leaseOwner);
                            deregisterLease = true;
                        }
                        if (!deregisterLease) continue;
                        if (expiredLeaseOwners == null) {
                            expiredLeaseOwners = new LinkedList<TaskProcessorMediatorKey>();
                        }
                        expiredLeaseOwners.add(leaseOwner);
                    }
                    if (expiredLeaseOwners != null) {
                        for (TaskProcessorMediatorKey leaseOwner : expiredLeaseOwners) {
                            DefaultServerLeaseMonitor.this.deregisterLease(leaseOwner);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Level.SEVERE)) break block8;
                    logger.log(Level.SEVERE, "LeaseValidator failed due to {0}", exception);
                }
            }
        }
    }
}

