/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.processing.internal.SubmissionKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SubmissionKeyPair
implements ExternalizableLite,
PortableObject {
    private SubmissionKey submissionKey;
    private Identifier resultIdentifier;

    public SubmissionKeyPair() {
    }

    public SubmissionKeyPair(SubmissionKey key, Identifier resultid) {
        this.submissionKey = key;
        this.resultIdentifier = resultid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resultIdentifier == null ? 0 : this.resultIdentifier.hashCode());
        result = 31 * result + (this.submissionKey == null ? 0 : this.submissionKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubmissionKeyPair other = (SubmissionKeyPair)obj;
        if (this.resultIdentifier == null ? other.resultIdentifier != null : !this.resultIdentifier.equals(other.resultIdentifier)) {
            return false;
        }
        return !(this.submissionKey == null ? other.submissionKey != null : !this.submissionKey.equals(other.submissionKey));
    }

    public SubmissionKey getKey() {
        return this.submissionKey;
    }

    public Identifier getResultId() {
        return this.resultIdentifier;
    }

    public String toString() {
        return "SKP:{" + this.submissionKey.toString() + "," + this.resultIdentifier.toString() + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.submissionKey = (SubmissionKey)ExternalizableHelper.readObject((DataInput)in);
        this.resultIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.submissionKey);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.resultIdentifier);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.submissionKey = (SubmissionKey)reader.readObject(0);
        this.resultIdentifier = (Identifier)reader.readObject(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.submissionKey);
        writer.writeObject(1, (Object)this.resultIdentifier);
    }
}

