/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.patterns.processing.internal.DefaultSubmission;
import com.oracle.coherence.patterns.processing.internal.ProcessingPattern;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.util.BinaryEntry;
import java.util.Map;
import java.util.Set;

public class SubmissionInterceptor
implements EventInterceptor {
    public void onEvent(Event event) {
        if (event instanceof EntryEvent) {
            this.processEntryEvent((EntryEvent)event);
        } else if (event instanceof TransferEvent) {
            this.processTransferEvent((TransferEvent)event);
        }
    }

    private void processEntryEvent(EntryEvent event) {
        for (BinaryEntry entry : event.getEntrySet()) {
            DefaultSubmission submission = (DefaultSubmission)entry.getValue();
            switch ((EntryEvent.Type)event.getType()) {
                case INSERTED: {
                    ProcessingPattern.ensureInfrastructureStarted(entry.getContext().getManager().getCacheFactory());
                    submission.onInserted(entry);
                    break;
                }
            }
        }
    }

    private void processTransferEvent(TransferEvent event) {
        Map map = event.getEntries();
        Set setEntries = (Set)map.get("coherence.patterns.processing.submissions");
        if (setEntries == null) {
            return;
        }
        for (BinaryEntry entry : setEntries) {
            DefaultSubmission submission = (DefaultSubmission)entry.getValue();
            switch ((TransferEvent.Type)event.getType()) {
                case ARRIVED: {
                    ProcessingPattern.ensureInfrastructureStarted(entry.getContext().getManager().getCacheFactory());
                    submission.onArrived(entry);
                    break;
                }
                case DEPARTING: {
                    submission.onDeparting(entry);
                }
            }
        }
    }
}

