/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.common.util.ObjectProxyFactory;
import com.oracle.coherence.patterns.processing.config.ProcessingPatternConfig;
import com.oracle.coherence.patterns.processing.dispatchers.DispatchController;
import com.oracle.coherence.patterns.processing.dispatchers.Dispatcher;
import com.oracle.coherence.patterns.processing.friends.DispatcherManager;
import com.oracle.coherence.patterns.processing.internal.DefaultDispatchController;
import com.oracle.coherence.patterns.processing.internal.DefaultDispatcherManager;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.Submission;
import com.oracle.coherence.patterns.processing.internal.SubmissionResult;
import com.oracle.coherence.patterns.processing.internal.task.DefaultServerLeaseMonitor;
import com.oracle.coherence.patterns.processing.internal.task.DefaultTaskProcessorDefinitionManager;
import com.oracle.coherence.patterns.processing.internal.task.ServerLeaseMonitor;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorDefinitionManager;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMBeanManager;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.oracle.coherence.patterns.processing.taskprocessor.ClientLeaseMaintainer;
import com.oracle.coherence.patterns.processing.taskprocessor.DefaultClientLeaseMaintainer;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.util.Base;

public class ProcessingPattern {
    ConfigurableCacheFactory m_ccf;
    Environment m_env;
    ProcessingPatternConfig m_config;
    DefaultDispatcherManager m_mgrDispatcher;
    DefaultTaskProcessorDefinitionManager m_mgrTaskProcessorDefinition;
    DefaultDispatchController m_dispatchController;
    ObjectProxyFactory<SubmissionResult> m_submissionResultProxyFactory;
    ObjectProxyFactory<TaskProcessorMediator> m_taskProcessorProxyFactory;
    ServerLeaseMonitor m_serverLeaseMonitor;
    TaskProcessorMBeanManager m_taskProcessorMBeanManager;
    private static boolean m_fStarted = false;

    public ProcessingPattern(ConfigurableCacheFactory ccf, Environment env, ProcessingPatternConfig config) {
        this.m_ccf = ccf;
        this.m_env = env;
        this.m_config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInfrastructureStarted(ConfigurableCacheFactory ccf) {
        if (m_fStarted) {
            return;
        }
        Class<ProcessingPatternConfig> clazz = ProcessingPatternConfig.class;
        synchronized (ProcessingPatternConfig.class) {
            if (!m_fStarted) {
                ProcessingPatternConfig config = (ProcessingPatternConfig)ccf.getResourceRegistry().getResource(ProcessingPatternConfig.class);
                Base.checkNotNull((Object)config, (String)"ProcessingPatternConfig");
                Environment env = (Environment)ccf.getResourceRegistry().getResource(Environment.class);
                Base.checkNotNull((Object)env, (String)"Environment");
                ProcessingPattern pp = new ProcessingPattern(ccf, env, config);
                pp.start();
                m_fStarted = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void start() {
        Environment env = this.m_env;
        this.m_taskProcessorProxyFactory = new ObjectProxyFactory("coherence.patterns.processing.taskprocessormediator", TaskProcessorMediator.class);
        env.registerResource(TaskProcessorMediator.class, this.m_taskProcessorProxyFactory);
        this.m_mgrDispatcher = new DefaultDispatcherManager(this.m_ccf);
        env.registerResource(DispatcherManager.class, this.m_mgrDispatcher);
        this.m_mgrTaskProcessorDefinition = new DefaultTaskProcessorDefinitionManager(env, this.m_ccf);
        env.registerResource(TaskProcessorDefinitionManager.class, this.m_mgrTaskProcessorDefinition);
        ObjectProxyFactory submissionResultProxyFactory = (ObjectProxyFactory)env.getResource(SubmissionResult.class);
        this.m_dispatchController = new DefaultDispatchController(this.m_ccf, (ObjectProxyFactory<SubmissionResult>)submissionResultProxyFactory);
        env.registerResource(DispatchController.class, this.m_dispatchController);
        this.m_serverLeaseMonitor = new DefaultServerLeaseMonitor(this.m_env, 20000L);
        env.registerResource(ServerLeaseMonitor.class, this.m_serverLeaseMonitor);
        this.m_taskProcessorMBeanManager = new TaskProcessorMBeanManager();
        env.registerResource(TaskProcessorMBeanManager.class, this.m_taskProcessorMBeanManager);
        try {
            for (TaskProcessorDefinition definition : this.m_config.getDefinitions()) {
                this.m_mgrTaskProcessorDefinition.registerTaskProcessor(definition);
            }
            this.m_mgrTaskProcessorDefinition.onDependenciesSatisfied(this.m_env);
        }
        catch (Throwable t) {
            throw Base.ensureRuntimeException((Throwable)t);
        }
        try {
            int i = 0;
            for (Dispatcher dispatcher : this.m_config.getDispatchers()) {
                this.m_mgrDispatcher.registerDispatcher(i++, dispatcher);
            }
            this.m_mgrDispatcher.onDependenciesSatisfied(env);
        }
        catch (Throwable t) {
            throw Base.ensureRuntimeException((Throwable)t);
        }
        this.m_dispatchController.onDependenciesSatisfied(env);
    }

    public static void createClientSideObjects(Environment env) {
        ObjectProxyFactory submissionProxyFactory = new ObjectProxyFactory("coherence.patterns.processing.submissions", Submission.class);
        env.registerResource(Submission.class, submissionProxyFactory);
        ObjectProxyFactory submissionResultProxyFactory = new ObjectProxyFactory("coherence.patterns.processing.submissionresults", SubmissionResult.class);
        env.registerResource(SubmissionResult.class, submissionResultProxyFactory);
        DefaultClientLeaseMaintainer clientLeaseMaintainer = new DefaultClientLeaseMaintainer(env, 10000L);
        env.registerResource(ClientLeaseMaintainer.class, clientLeaseMaintainer);
    }
}

