/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.util.ChangeIndication;
import com.oracle.coherence.patterns.processing.SubmissionState;
import com.oracle.coherence.patterns.processing.internal.SubmissionKey;
import com.oracle.coherence.patterns.processing.internal.SubmissionResult;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultSubmissionResult
implements ExternalizableLite,
PortableObject,
SubmissionResult,
ChangeIndication {
    public static final String CACHENAME = "coherence.patterns.processing.submissionresults";
    private static final Logger logger = Logger.getLogger(DefaultSubmissionResult.class.getName());
    private long executionTime;
    private long latency;
    private long submissionTime;
    private long startTime;
    private Object progress;
    private Identifier submissionResultID;
    private Object result;
    private SubmissionKey submissionKey;
    private SubmissionState submissionState;
    private Identifier sessionIdentifier;
    private Object owner;
    private boolean isResuming;
    private transient boolean changed;

    public DefaultSubmissionResult() {
        this.submissionState = SubmissionState.INITIAL;
        this.progress = 0;
    }

    public DefaultSubmissionResult(Identifier submissionResultID, SubmissionKey submissionKey, Identifier submitterIdentifier) {
        this.submissionResultID = submissionResultID;
        this.submissionKey = submissionKey;
        this.sessionIdentifier = submitterIdentifier;
        this.result = null;
        this.submissionState = SubmissionState.INITIAL;
        this.progress = null;
    }

    public DefaultSubmissionResult(Identifier submissionResultID, SubmissionKey submissionKey, Identifier sessionid, String submissionState) {
        this(submissionResultID, submissionKey, sessionid);
        this.submissionState = Enum.valueOf(SubmissionState.class, submissionState);
        this.progress = null;
        if (this.submissionState == SubmissionState.SUBMITTED) {
            this.setSubmissionTime(System.currentTimeMillis());
        }
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public Identifier getID() {
        return this.submissionResultID;
    }

    @Override
    public long getLatency() {
        return this.latency;
    }

    @Override
    public Object getProgress() {
        return this.progress;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public SubmissionKey getSubmissionKey() {
        return this.submissionKey;
    }

    @Override
    public SubmissionState getSubmissionState() {
        return this.submissionState;
    }

    @Override
    public long getSubmissionTime() {
        return this.submissionTime;
    }

    @Override
    public Identifier getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    @Override
    public void changeSessionIdentifier(Identifier newIdentifier) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " Changing sessionIdentifier from:" + this.sessionIdentifier + " to:" + newIdentifier);
        }
        this.sessionIdentifier = newIdentifier;
        this.setChanged();
    }

    @Override
    public boolean isFinalState() {
        return this.submissionState != null && this.submissionState.isFinalState();
    }

    public void setExecutionTime(long lExecutionTime) {
        this.executionTime = lExecutionTime;
        this.setChanged();
    }

    public void setLatency(long lLatency) {
        this.latency = lLatency;
        this.setChanged();
    }

    private void setStartTime(long currentTimeMillis) {
        this.startTime = currentTimeMillis;
        this.setChanged();
    }

    @Override
    public void setProgress(Object oProgress) {
        this.progress = oProgress;
        this.setChanged();
    }

    @Override
    public void setResult(Object oResult) {
        this.result = oResult;
        this.setChanged();
    }

    private void setSubmissionState(SubmissionState state) {
        this.submissionState = state;
        this.setChanged();
    }

    public void setSubmissionTime(long lSubmissionTime) {
        this.submissionTime = lSubmissionTime;
        this.setChanged();
    }

    @Override
    public boolean processingStarted(Object processingOwner) {
        if (this.owner != processingOwner) {
            if (this.owner == null) {
                return false;
            }
            if (!this.owner.equals(processingOwner)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Can not start processing {0} a different owner {1} is assigned, {2} tried to process it.", new Object[]{this, this.owner, processingOwner});
                }
                return false;
            }
        }
        if (this.getSubmissionState() == SubmissionState.ASSIGNED) {
            this.setLatency(System.currentTimeMillis() - this.getSubmissionTime());
        }
        if (this.getSubmissionState() == SubmissionState.ASSIGNED || this.getSubmissionState() == SubmissionState.SUSPENDED || this.getSubmissionState() == SubmissionState.EXECUTING) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.EXECUTING});
            }
            this.setStartTime(System.currentTimeMillis());
            this.setSubmissionState(SubmissionState.EXECUTING);
            this.setChanged();
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Could not set {0} to EXECUTING because it was not SUSPENDED or SUBMITTED or ASSIGNED", this);
        }
        return false;
    }

    @Override
    public boolean processingFailed(Object oFailureResult) {
        if (this.getSubmissionState() == SubmissionState.EXECUTING || this.getSubmissionState() == SubmissionState.RETRY || this.getSubmissionState() == SubmissionState.SUBMITTED || this.getSubmissionState() == SubmissionState.ASSIGNED || this.getSubmissionState() == SubmissionState.SUSPENDED) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.FAILED});
            }
            this.setSubmissionState(SubmissionState.FAILED);
            this.setResult(oFailureResult);
            this.setChanged();
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Could not set {0} to FAILED because it was not EXECUTING, RETRY, SUBMITTED, ASSIGNED or SUSPENDED", this);
        }
        return false;
    }

    @Override
    public Object assign(Object owner) {
        SubmissionState state = this.getSubmissionState();
        if (state == SubmissionState.SUBMITTED || state == SubmissionState.SUSPENDED || state == SubmissionState.RETRY) {
            if (state == SubmissionState.SUSPENDED || state == SubmissionState.RETRY) {
                this.isResuming = true;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.ASSIGNED});
            }
            this.setSubmissionState(SubmissionState.ASSIGNED);
            this.setOwner(owner);
            this.setChanged();
            return null;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Could not set {0} to ASSIGNED because it was not in SUBMITTED, SUSPENDED or RETRY state", this);
        }
        return owner;
    }

    private void setOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public boolean processingSucceeded(Object oResult) {
        if (this.getSubmissionState() == SubmissionState.EXECUTING) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.DONE});
            }
            this.setSubmissionState(SubmissionState.DONE);
            this.setResult(oResult);
            this.setExecutionTime(this.getExecutionTime() + (System.currentTimeMillis() - this.getStartTime()));
            this.setChanged();
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Could not set {0} to DONE because it was not EXECUTING", this);
        }
        return false;
    }

    @Override
    public boolean retry() {
        if (!this.getSubmissionState().isFinalState()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.RETRY});
            }
            this.setSubmissionState(SubmissionState.RETRY);
            this.owner = null;
            this.setChanged();
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Could not set {0} to RETRY because it was in final state", this);
        }
        return false;
    }

    @Override
    public boolean cancelSubmission() {
        if (!this.getSubmissionState().isFinalState()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.CANCELLED});
            }
            this.setSubmissionState(SubmissionState.CANCELLED);
            this.setChanged();
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.FINER, "Couldn't set SubmissionResult {0} to CANCELLED because it was in the final state {1}", new Object[]{this, this.getSubmissionState()});
        }
        return false;
    }

    private long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean suspendExecution(Object oResult) {
        if (this.getSubmissionState() == SubmissionState.EXECUTING || this.getSubmissionState() == SubmissionState.RETRY) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.SUSPENDED});
            }
            this.setExecutionTime(this.getExecutionTime() + (System.currentTimeMillis() - this.getStartTime()));
            this.setSubmissionState(SubmissionState.SUSPENDED);
            this.setResult(oResult);
            this.setChanged();
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Could not set {0} to SUSPENDED because it was not EXECUTING or in RETRY", this);
        }
        return false;
    }

    @Override
    public boolean submitted(long currentTimeMillis) {
        if (this.getSubmissionState() == SubmissionState.INITIAL) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "SubmissionResult {0} changing state from {1} to {2} ", new Object[]{this, this.getSubmissionState(), SubmissionState.SUBMITTED});
            }
            this.setSubmissionState(SubmissionState.SUBMITTED);
            this.setSubmissionTime(currentTimeMillis);
            this.setChanged();
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Could not set {0} to SUBMITTED because it was not INITIAL", this);
        }
        return false;
    }

    @Override
    public boolean isResuming() {
        return this.isResuming;
    }

    public String toString() {
        return "DefaultSubmissionResult [" + (this.owner != null ? "owner=" + this.owner + ", " : "") + (this.submissionState != null ? "submissionState=" + (Object)((Object)this.submissionState) + ", " : "") + (this.sessionIdentifier != null ? "sessionIdentifier=" + this.sessionIdentifier + ", " : "") + (this.submissionKey != null ? "submissionKey=" + this.submissionKey + ", " : "") + (this.submissionResultID != null ? "submissionResultID=" + this.submissionResultID + ", " : "") + (this.progress != null ? "progress=" + this.progress + ", " : "") + (this.result != null ? "result=" + this.result + ", " : "") + "latency=" + this.latency + ", executionTime=" + this.executionTime + ", isResuming=" + this.isResuming + ", startTime=" + this.startTime + ", submissionTime=" + this.submissionTime + "]";
    }

    public void beforeChange() {
        this.changed = false;
    }

    public boolean changed() {
        return this.changed;
    }

    private void setChanged() {
        this.changed = true;
    }

    public void readExternal(DataInput in) throws IOException {
        this.submissionResultID = (Identifier)ExternalizableHelper.readObject((DataInput)in);
        this.submissionKey = (SubmissionKey)ExternalizableHelper.readObject((DataInput)in);
        this.sessionIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
        this.result = ExternalizableHelper.readObject((DataInput)in);
        this.submissionState = Enum.valueOf(SubmissionState.class, ExternalizableHelper.readSafeUTF((DataInput)in));
        this.progress = ExternalizableHelper.readObject((DataInput)in);
        this.submissionTime = ExternalizableHelper.readLong((DataInput)in);
        this.latency = ExternalizableHelper.readLong((DataInput)in);
        this.executionTime = ExternalizableHelper.readLong((DataInput)in);
        this.startTime = ExternalizableHelper.readLong((DataInput)in);
        this.isResuming = in.readBoolean();
        this.owner = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.submissionResultID);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.submissionKey);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.sessionIdentifier);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.result);
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.submissionState.name());
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.progress);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.submissionTime);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.latency);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.executionTime);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.startTime);
        out.writeBoolean(this.isResuming);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.owner);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.submissionResultID = (Identifier)reader.readObject(0);
        this.submissionKey = (SubmissionKey)reader.readObject(1);
        this.sessionIdentifier = (Identifier)reader.readObject(2);
        this.result = reader.readObject(3);
        this.submissionState = Enum.valueOf(SubmissionState.class, reader.readString(4));
        this.progress = reader.readObject(5);
        this.submissionTime = reader.readLong(6);
        this.latency = reader.readLong(7);
        this.executionTime = reader.readLong(8);
        this.startTime = reader.readLong(9);
        this.isResuming = reader.readBoolean(10);
        this.owner = reader.readObject(11);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.submissionResultID);
        writer.writeObject(1, (Object)this.submissionKey);
        writer.writeObject(2, (Object)this.sessionIdentifier);
        writer.writeObject(3, this.result);
        writer.writeString(4, this.submissionState.name());
        writer.writeObject(5, this.progress);
        writer.writeLong(6, this.submissionTime);
        writer.writeLong(7, this.latency);
        writer.writeLong(8, this.executionTime);
        writer.writeLong(9, this.startTime);
        writer.writeBoolean(10, this.isResuming);
        writer.writeObject(11, this.owner);
    }
}

