/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.util.ObjectProxyFactory;
import com.oracle.coherence.patterns.processing.SubmissionOutcome;
import com.oracle.coherence.patterns.processing.SubmissionOutcomeListener;
import com.oracle.coherence.patterns.processing.SubmissionRetentionPolicy;
import com.oracle.coherence.patterns.processing.SubmissionState;
import com.oracle.coherence.patterns.processing.internal.SubmissionResult;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DefaultSubmissionOutcome
implements SubmissionOutcome {
    private long executionDuration;
    private long latency;
    private long submissionTime;
    private Object result;
    private final Identifier resultIdentifier;
    private SubmissionOutcomeListener submissionOutcomeListener;
    private SubmissionState submissionState;
    private SubmissionResult submissionResult;
    SubmissionRetentionPolicy retentionPolicy;
    private ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory;

    public DefaultSubmissionOutcome(Identifier resultIdentifier, SubmissionRetentionPolicy retentionPolicy, ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory) {
        this.resultIdentifier = resultIdentifier;
        this.retentionPolicy = retentionPolicy;
        this.submissionResultProxyFactory = submissionResultProxyFactory;
    }

    public DefaultSubmissionOutcome(Identifier resultIdentifier, SubmissionOutcomeListener listener, SubmissionResult submissionResult, SubmissionRetentionPolicy retentionPolicy, ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory) {
        this.resultIdentifier = resultIdentifier;
        this.submissionOutcomeListener = listener;
        this.submissionResult = submissionResult;
        this.retentionPolicy = retentionPolicy;
        this.submissionResultProxyFactory = submissionResultProxyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptProcessResult(Object result, SubmissionState state, long submissionTime, long latency, long executionDuration) {
        DefaultSubmissionOutcome defaultSubmissionOutcome = this;
        synchronized (defaultSubmissionOutcome) {
            this.result = result;
            this.submissionTime = submissionTime;
            this.latency = latency;
            this.executionDuration = executionDuration;
            this.submissionState = state;
            this.notify();
            if (this.submissionOutcomeListener != null) {
                if (this.submissionState == SubmissionState.FAILED) {
                    this.submissionOutcomeListener.onFailed(this.result);
                } else {
                    this.submissionOutcomeListener.onDone(this.result);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() throws InterruptedException, ExecutionException {
        DefaultSubmissionOutcome defaultSubmissionOutcome = this;
        synchronized (defaultSubmissionOutcome) {
            if (!this.isFinalState()) {
                this.wait();
            }
            if (this.result instanceof Exception) {
                throw new ExecutionException("Execution Failed", (Exception)this.result);
            }
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        DefaultSubmissionOutcome defaultSubmissionOutcome = this;
        synchronized (defaultSubmissionOutcome) {
            if (!this.isFinalState()) {
                timeUnit.timedWait(this, timeout);
            }
            if (!this.isFinalState()) {
                throw new TimeoutException();
            }
            if (this.result instanceof Exception) {
                throw new ExecutionException("Execution Failed", (Exception)this.result);
            }
            return this.result;
        }
    }

    @Override
    public long getExecutionDuration() {
        return this.executionDuration;
    }

    @Override
    public Object getProgress() {
        return this.submissionResult.getProgress();
    }

    @Override
    public SubmissionState getSubmissionState() {
        return this.submissionState;
    }

    @Override
    public long getSubmissionTime() {
        return this.submissionTime;
    }

    @Override
    public long getWaitDuration() {
        return this.latency;
    }

    public void checkSubmissionResult() {
        this.submissionState = this.submissionResult.getSubmissionState();
        if (this.submissionState != null && this.submissionState.isFinalState()) {
            SubmissionResult local = (SubmissionResult)this.submissionResultProxyFactory.getLocalCopyOfRemoteObject((Object)this.resultIdentifier);
            this.result = local.getResult();
            this.submissionTime = local.getSubmissionTime();
            this.latency = local.getLatency();
            this.executionDuration = local.getExecutionTime();
        }
    }

    @Override
    public boolean isFinalState() {
        return this.submissionState != null && this.submissionState.isFinalState();
    }

    public void onProgress(Object object) {
        if (this.submissionOutcomeListener != null) {
            this.submissionOutcomeListener.onProgress(object);
        }
    }

    public void onStarted() {
        if (this.submissionOutcomeListener != null) {
            this.submissionOutcomeListener.onStarted();
        }
    }

    public void onSuspended() {
        if (this.submissionOutcomeListener != null) {
            this.submissionOutcomeListener.onSuspended();
        }
    }

    @Override
    public Identifier getIdentifier() {
        return this.resultIdentifier;
    }

    @Override
    public SubmissionRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }
}

