/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.patterns.processing.DispatcherFilter;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DefaultSubmissionConfiguration
implements ExternalizableLite,
PortableObject,
SubmissionConfiguration {
    private Object groupAffinity;
    private long submissionDelay;
    private Map configurationDataMap = new HashMap();
    private DispatcherFilter dispatcherFilter;

    public DefaultSubmissionConfiguration() {
    }

    public DefaultSubmissionConfiguration(Map configurationMap) {
        this();
        if (configurationMap != null) {
            this.configurationDataMap = configurationMap;
        }
    }

    public DefaultSubmissionConfiguration(long lDelay, DispatcherFilter dispatcherFilter) {
        this();
        this.submissionDelay = lDelay;
        this.dispatcherFilter = dispatcherFilter;
    }

    @Override
    public Object getGroupAffinity() {
        return this.groupAffinity;
    }

    @Override
    public Map getConfigurationDataMap() {
        return this.configurationDataMap;
    }

    @Override
    public long getSubmissionDelay() {
        return this.submissionDelay;
    }

    @Override
    public DispatcherFilter getDispatcherFilter() {
        return this.dispatcherFilter;
    }

    public void setGroupAffinity(Object oGroupAffinity) {
        this.groupAffinity = oGroupAffinity;
    }

    public void setConfigurationDataMap(Map data) {
        this.configurationDataMap = data;
    }

    public void setSubmissionDelay(long lSubmissionDelay) {
        this.submissionDelay = lSubmissionDelay;
    }

    public void setDispatcherFilter(DispatcherFilter dispatcherFilter) {
        this.dispatcherFilter = dispatcherFilter;
    }

    public String toString() {
        return String.format("%s{requestDelay=%d, data=[%s] affinity=%s}", this.getClass().getName(), this.submissionDelay, this.configurationDataMap, this.groupAffinity);
    }

    public void readExternal(DataInput in) throws IOException {
        this.submissionDelay = ExternalizableHelper.readLong((DataInput)in);
        this.configurationDataMap = new HashMap();
        ExternalizableHelper.readMap((DataInput)in, (Map)this.configurationDataMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        this.groupAffinity = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.submissionDelay);
        ExternalizableHelper.writeMap((DataOutput)out, (Map)this.configurationDataMap);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.groupAffinity);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.submissionDelay = reader.readLong(0);
        this.configurationDataMap = reader.readMap(1, new HashMap());
        this.groupAffinity = reader.readObject(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.submissionDelay);
        writer.writeMap(1, this.configurationDataMap);
        writer.writeObject(2, this.groupAffinity);
    }
}

