/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.util.ChangeIndication;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.oracle.coherence.patterns.processing.SubmissionState;
import com.oracle.coherence.patterns.processing.dispatchers.DispatchController;
import com.oracle.coherence.patterns.processing.internal.DefaultPendingSubmission;
import com.oracle.coherence.patterns.processing.internal.DefaultSubmissionContent;
import com.oracle.coherence.patterns.processing.internal.Submission;
import com.oracle.coherence.patterns.processing.internal.SubmissionContent;
import com.oracle.coherence.patterns.processing.internal.SubmissionKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UUID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultSubmission
implements PortableObject,
ExternalizableLite,
Submission,
ChangeIndication {
    private static DispatchController controller;
    private static final Logger logger;
    public static final String CACHENAME = "coherence.patterns.processing.submissions";
    private SubmissionContent payload;
    private Identifier resultIdentifier;
    private UUID submissionUUID;
    private Identifier sessionIdentifier;
    private transient boolean changed;

    public DefaultSubmission() {
    }

    public DefaultSubmission(UUID submissionUUID, Object payload, SubmissionConfiguration configurationData, Identifier resultIdentifier, Identifier sessionId) {
        this.submissionUUID = submissionUUID;
        this.payload = new DefaultSubmissionContent(payload, configurationData);
        this.resultIdentifier = resultIdentifier;
        this.sessionIdentifier = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDispatchController(DispatchController dispatchController) {
        Class<DefaultSubmission> clazz = DefaultSubmission.class;
        synchronized (DefaultSubmission.class) {
            controller = dispatchController;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DispatchController getDispatchController() {
        Class<DefaultSubmission> clazz = DefaultSubmission.class;
        synchronized (DefaultSubmission.class) {
            if (controller == null) {
                throw new RuntimeException("DispatchController not injected for DefaultSubmission");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return controller;
        }
    }

    @Override
    public SubmissionKey generateKey() {
        return new SubmissionKey(this.payload.getSubmissionConfiguration().getGroupAffinity(), this.getUUID());
    }

    @Override
    public SubmissionContent getContent() {
        return this.payload;
    }

    @Override
    public Identifier getResultIdentifier() {
        return this.resultIdentifier;
    }

    @Override
    public Identifier getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    @Override
    public void changeSessionIdentifier(Identifier newIdentifier) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " Changing sessionIdentifier from:" + this.sessionIdentifier + " to:" + newIdentifier);
        }
        this.sessionIdentifier = newIdentifier;
        this.setChanged();
    }

    @Override
    public UUID getUUID() {
        return this.submissionUUID;
    }

    @Override
    public boolean reDispatch(long delay) {
        DefaultSubmission.getDispatchController().accept(new DefaultPendingSubmission(this.generateKey(), this.resultIdentifier, this.payload.getSubmissionConfiguration(), delay));
        return true;
    }

    public String toString() {
        return String.format("%s{uuid=%s, payload=%s, requestdata=%s, resultIdentifier=%s}", this.getClass().getName(), this.submissionUUID, this.payload, this.payload.getSubmissionConfiguration(), this.resultIdentifier);
    }

    public void onDeparting(BinaryEntry entry) {
        DefaultSubmission.getDispatchController().discard(new DefaultPendingSubmission((SubmissionKey)entry.getKey(), this.getResultIdentifier(), this.getContent().getSubmissionConfiguration(), 0L));
    }

    public void onInserted(BinaryEntry entry) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, " {0} was received for dispatch", this);
        }
        DefaultSubmission.getDispatchController().accept(new DefaultPendingSubmission((SubmissionKey)entry.getKey(), this.getResultIdentifier(), this.getContent().getSubmissionConfiguration(), this.getContent().getSubmissionConfiguration().getSubmissionDelay()));
    }

    public void onArrived(BinaryEntry entry) {
        block6: {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, " {0} was received for dispatch", this);
            }
            try {
                SubmissionState state = DefaultSubmission.getDispatchController().getSubmissionState(this.resultIdentifier);
                if (!state.isFinalState()) {
                    DefaultSubmission.getDispatchController().acceptTransferredSubmission(new DefaultPendingSubmission((SubmissionKey)entry.getKey(), this.getResultIdentifier(), this.getContent().getSubmissionConfiguration(), this.getContent().getSubmissionConfiguration().getSubmissionDelay()));
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Submission {0} was failed over and is in a final state.", this);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "Submission {0} was failed over but is already removed. Exception caught: {1}.", new Object[]{this, e});
            }
        }
    }

    public void beforeChange() {
        this.changed = false;
    }

    public boolean changed() {
        return this.changed;
    }

    private void setChanged() {
        this.changed = true;
    }

    public void readExternal(DataInput in) throws IOException {
        this.submissionUUID = (UUID)ExternalizableHelper.readObject((DataInput)in);
        this.payload = (SubmissionContent)ExternalizableHelper.readObject((DataInput)in);
        this.resultIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
        this.sessionIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.submissionUUID);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.payload);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.resultIdentifier);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.sessionIdentifier);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.submissionUUID = (UUID)reader.readObject(0);
        this.payload = (SubmissionContent)reader.readObject(1);
        this.resultIdentifier = (Identifier)reader.readObject(2);
        this.sessionIdentifier = (Identifier)reader.readObject(3);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.submissionUUID);
        writer.writeObject(1, (Object)this.payload);
        writer.writeObject(2, (Object)this.resultIdentifier);
        writer.writeObject(3, (Object)this.sessionIdentifier);
    }

    static {
        logger = Logger.getLogger(DefaultSubmission.class.getName());
    }
}

