/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.identifiers.UUIDBasedIdentifier;
import com.oracle.coherence.common.threading.ExecutorServiceFactory;
import com.oracle.coherence.common.threading.ThreadFactories;
import com.oracle.coherence.common.util.ObjectProxyFactory;
import com.oracle.coherence.patterns.processing.ProcessingSession;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.oracle.coherence.patterns.processing.SubmissionOutcome;
import com.oracle.coherence.patterns.processing.SubmissionOutcomeListener;
import com.oracle.coherence.patterns.processing.SubmissionRetentionPolicy;
import com.oracle.coherence.patterns.processing.SubmissionState;
import com.oracle.coherence.patterns.processing.internal.DefaultEnvironment;
import com.oracle.coherence.patterns.processing.internal.DefaultSubmission;
import com.oracle.coherence.patterns.processing.internal.DefaultSubmissionOutcome;
import com.oracle.coherence.patterns.processing.internal.DefaultSubmissionResult;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.ProcessingPattern;
import com.oracle.coherence.patterns.processing.internal.Submission;
import com.oracle.coherence.patterns.processing.internal.SubmissionKey;
import com.oracle.coherence.patterns.processing.internal.SubmissionResult;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.UUID;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalPut;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultProcessingSession
implements ProcessingSession {
    private static final Logger logger = Logger.getLogger(DefaultProcessingSession.class.getName());
    private final NamedCache submissionCache;
    private final ConcurrentHashMap<Object, DefaultSubmissionOutcome> submissionOutcomeMap;
    private final NamedCache submissionResultsCache;
    private final Identifier sessionId;
    private ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory;
    private ObjectProxyFactory<Submission> submissionProxyFactory;
    private Object shutdownSync;
    MapListener submissionResultsListener;
    private final ExecutorService executorService;

    public DefaultProcessingSession(Identifier sessionIdentifier) {
        ConfigurableCacheFactory ccFactory = CacheFactory.getConfigurableCacheFactory();
        try {
            ccFactory.activate();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Environment environment = (Environment)ccFactory.getResourceRegistry().getResource(Environment.class);
        if (environment == null) {
            environment = new DefaultEnvironment();
            ProcessingPattern.createClientSideObjects(environment);
            ccFactory.getResourceRegistry().registerResource(Environment.class, (Object)environment);
        }
        this.executorService = ExecutorServiceFactory.newSingleThreadScheduledExecutor((ThreadFactory)ThreadFactories.newThreadFactory((boolean)true, (String)"DefaultProcessingSession", null));
        this.shutdownSync = new Object();
        this.sessionId = sessionIdentifier;
        this.submissionOutcomeMap = new ConcurrentHashMap();
        this.submissionResultProxyFactory = (ObjectProxyFactory)environment.getResource(SubmissionResult.class);
        if (this.submissionResultProxyFactory == null) {
            throw new RuntimeException("ProcessingPattern not correctly initialized. Make sure the cache configuration defines the use of the Processing Pattern.");
        }
        this.submissionResultsCache = ccFactory.ensureCache("coherence.patterns.processing.submissionresults", null);
        this.submissionProxyFactory = (ObjectProxyFactory)environment.getResource(Submission.class);
        this.submissionCache = ccFactory.ensureCache("coherence.patterns.processing.submissions", null);
        this.setSubmissionResultsListener();
    }

    public DefaultProcessingSession(ConfigurableCacheFactory ccFactory, ObjectProxyFactory<Submission> submissionProxyFactory, ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory, Identifier sessionIdentifier) {
        this.executorService = ExecutorServiceFactory.newSingleThreadScheduledExecutor((ThreadFactory)ThreadFactories.newThreadFactory((boolean)true, (String)"DefaultProcessingSession", null));
        this.shutdownSync = new Object();
        this.sessionId = sessionIdentifier;
        this.submissionOutcomeMap = new ConcurrentHashMap();
        this.submissionResultProxyFactory = submissionResultProxyFactory;
        if (submissionResultProxyFactory == null) {
            throw new RuntimeException("ProcessingPattern not correctly initialized. Make sure the cache configuration defines the use of the Processing Pattern.");
        }
        this.submissionResultsCache = ccFactory.ensureCache("coherence.patterns.processing.submissionresults", null);
        this.submissionProxyFactory = submissionProxyFactory;
        this.submissionCache = ccFactory.ensureCache("coherence.patterns.processing.submissions", null);
        this.setSubmissionResultsListener();
    }

    private void setSubmissionResultsListener() {
        this.submissionResultsListener = new MultiplexingMapListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onMapEvent(MapEvent mapEvent) {
                if (mapEvent.getId() == 1 || mapEvent.getId() == 2) {
                    Object object = DefaultProcessingSession.this.shutdownSync;
                    synchronized (object) {
                        SubmissionResult oResult = (SubmissionResult)mapEvent.getNewValue();
                        DefaultProcessingSession.this.handleResultChange(oResult, mapEvent.getKey());
                    }
                }
            }
        };
        this.submissionResultsCache.addMapListener(this.submissionResultsListener, (Filter)new MapEventFilter(3, (Filter)new EqualsFilter("getSessionIdentifier", (Object)this.sessionId)), false);
    }

    protected void handleResultChange(SubmissionResult submissionResult, Object key) {
        DefaultSubmissionOutcome submissionOutcome = this.submissionOutcomeMap.get(key);
        if (submissionResult.isFinalState()) {
            if (submissionOutcome != null) {
                submissionOutcome.acceptProcessResult(submissionResult.getResult(), submissionResult.getSubmissionState(), submissionResult.getSubmissionTime(), submissionResult.getLatency(), submissionResult.getExecutionTime());
            }
        } else if (submissionOutcome != null) {
            if (submissionResult.getSubmissionState() == SubmissionState.SUSPENDED) {
                submissionOutcome.onSuspended();
            } else if (submissionResult.getSubmissionState() == SubmissionState.EXECUTING) {
                if (submissionResult.getProgress() == null) {
                    submissionOutcome.onStarted();
                } else {
                    submissionOutcome.onProgress(submissionResult.getProgress());
                }
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " Result update:" + submissionResult.getID() + ":" + key + " submissionoutcome is null BUT NOT IN FINAL STATE");
        }
        if (submissionOutcome != null) {
            if (submissionOutcome.isFinalState()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Submission is, done REMOVING submission {0} and submissionResult {1}", new Object[]{submissionResult.getSubmissionKey(), key});
                }
                if (submissionOutcome.getRetentionPolicy() == SubmissionRetentionPolicy.RemoveOnFinalState) {
                    this.removeCacheObjectsAsynch(submissionResult.getSubmissionKey(), submissionResult.getID());
                }
                this.submissionOutcomeMap.remove(key);
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " Result update:" + submissionResult.getID() + ":" + key + " submissionoutcome is null");
        }
    }

    private void removeCacheObjectsAsynch(final SubmissionKey submissionKey, final Identifier resultId) {
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = DefaultProcessingSession.this.shutdownSync;
                synchronized (object) {
                    try {
                        DefaultProcessingSession.this.submissionProxyFactory.destroyRemoteObject((Object)submissionKey);
                        DefaultProcessingSession.this.submissionResultProxyFactory.destroyRemoteObject((Object)resultId);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Failed to remove cache objects with result key {0} and submission key {1} due to {2}", new Object[]{resultId, submissionKey, e});
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmissionOutcome submit(Object oPayload, SubmissionConfiguration oRequestData) throws Throwable {
        Object object = this.shutdownSync;
        synchronized (object) {
            DefaultSubmission submission = new DefaultSubmission(new UUID(), oPayload, oRequestData, UUIDBasedIdentifier.newInstance(), this.sessionId);
            DefaultSubmissionOutcome submissionOutcome = new DefaultSubmissionOutcome(submission.getResultIdentifier(), SubmissionRetentionPolicy.RemoveOnFinalState, this.submissionResultProxyFactory);
            this.submissionOutcomeMap.put(submission.getResultIdentifier(), submissionOutcome);
            this.storeInCache(submission);
            return submissionOutcome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmissionOutcome submit(Object oPayload, SubmissionConfiguration oRequestData, SubmissionOutcomeListener oListener) throws Throwable {
        Object object = this.shutdownSync;
        synchronized (object) {
            DefaultSubmission submission = new DefaultSubmission(new UUID(), oPayload, oRequestData, UUIDBasedIdentifier.newInstance(), this.sessionId);
            SubmissionResult submissionResult = (SubmissionResult)this.submissionResultProxyFactory.getProxy((Object)submission.getResultIdentifier());
            DefaultSubmissionOutcome submissionOutcome = new DefaultSubmissionOutcome(submission.getResultIdentifier(), oListener, submissionResult, SubmissionRetentionPolicy.RemoveOnFinalState, this.submissionResultProxyFactory);
            this.submissionOutcomeMap.put(submission.getResultIdentifier(), submissionOutcome);
            this.storeInCache(submission);
            return submissionOutcome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmissionOutcome submit(Object oPayload, SubmissionConfiguration oConfiguration, Identifier identifier, SubmissionRetentionPolicy retentionPolicy, SubmissionOutcomeListener oListener) throws Throwable {
        Object object = this.shutdownSync;
        synchronized (object) {
            DefaultSubmission submission = new DefaultSubmission(new UUID(), oPayload, oConfiguration, identifier, this.sessionId);
            SubmissionResult submissionResult = (SubmissionResult)this.submissionResultProxyFactory.getProxy((Object)submission.getResultIdentifier());
            DefaultSubmissionOutcome submissionOutcome = new DefaultSubmissionOutcome(submission.getResultIdentifier(), oListener, submissionResult, retentionPolicy, this.submissionResultProxyFactory);
            if (!this.submissionOutcomeMap.containsKey(submission.getResultIdentifier())) {
                this.submissionOutcomeMap.put(submission.getResultIdentifier(), submissionOutcome);
                try {
                    this.storeInCache(submission);
                }
                catch (IllegalStateException e) {
                    this.submissionOutcomeMap.remove(submission.getResultIdentifier());
                    throw e;
                }
            } else {
                throw new IllegalStateException("Identifier:" + submission.getResultIdentifier() + " already exists.");
            }
            return submissionOutcome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmissionOutcome acquireSubmission(Identifier identifier, SubmissionRetentionPolicy retentionPolicy, SubmissionOutcomeListener oListener) {
        Object object = this.shutdownSync;
        synchronized (object) {
            SubmissionResult submissionResult = (SubmissionResult)this.submissionResultProxyFactory.getProxy((Object)identifier);
            SubmissionKey submissionKey = submissionResult.getSubmissionKey();
            Submission submission = (Submission)this.submissionProxyFactory.getProxy((Object)submissionKey);
            submission.changeSessionIdentifier(this.sessionId);
            submissionResult.changeSessionIdentifier(this.sessionId);
            DefaultSubmissionOutcome oResult = new DefaultSubmissionOutcome(identifier, oListener, submissionResult, retentionPolicy, this.submissionResultProxyFactory);
            this.submissionOutcomeMap.put(identifier, oResult);
            oResult.checkSubmissionResult();
            return oResult;
        }
    }

    @Override
    public boolean discardSubmission(Identifier identifier) throws Throwable {
        SubmissionResult submissionResult;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " discardSubmission for " + identifier);
        }
        if ((submissionResult = (SubmissionResult)this.submissionResultProxyFactory.getLocalCopyOfRemoteObject((Object)identifier)).getSessionIdentifier().equals(this.sessionId)) {
            this.submissionResultProxyFactory.destroyRemoteObject((Object)identifier);
            this.submissionProxyFactory.destroyRemoteObject((Object)submissionResult.getSubmissionKey());
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, " discardSubmission for " + identifier + " successful");
            }
            this.submissionOutcomeMap.remove(identifier);
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " discardSubmission - failed to remove - submissionResult owned by  " + submissionResult.getSessionIdentifier());
        }
        return false;
    }

    @Override
    public boolean cancelSubmission(Identifier identifier) {
        SubmissionResult submissionResult = (SubmissionResult)this.submissionResultProxyFactory.getProxy((Object)identifier);
        return submissionResult.cancelSubmission();
    }

    @Override
    public void releaseSubmission(SubmissionOutcome submissionOutcome) {
        this.submissionOutcomeMap.remove(submissionOutcome.getIdentifier());
    }

    private void storeInCache(DefaultSubmission submission) throws Throwable {
        this.submissionResultProxyFactory.createRemoteObjectIfNotExists((Object)submission.getResultIdentifier(), DefaultSubmissionResult.class, new Object[]{submission.getResultIdentifier(), submission.generateKey(), submission.getSessionIdentifier(), SubmissionState.SUBMITTED.name()});
        NotFilter filter = new NotFilter((Filter)PresentFilter.INSTANCE);
        this.submissionCache.invoke((Object)submission.generateKey(), (InvocableMap.EntryProcessor)new ConditionalPut((Filter)filter, (Object)submission));
    }

    @Override
    public Iterator<Identifier> getIdentifierIterator() {
        EqualsFilter filter = new EqualsFilter("getSessionIdentifier", (Object)this.sessionId);
        ArrayList<Identifier> identifierList = new ArrayList<Identifier>();
        for (Map.Entry entry : this.submissionResultsCache.entrySet((Filter)filter)) {
            Identifier key = (Identifier)entry.getKey();
            identifierList.add(key);
        }
        return identifierList.iterator();
    }

    @Override
    public boolean submissionExists(Identifier submissionIdentifier) {
        return this.submissionResultsCache.containsKey((Object)submissionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.shutdownSync;
        synchronized (object) {
            this.submissionResultsCache.removeMapListener(this.submissionResultsListener);
        }
        this.executorService.shutdown();
    }
}

