/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.oracle.coherence.patterns.processing.dispatchers.PendingSubmission;
import com.oracle.coherence.patterns.processing.internal.Submission;
import com.oracle.coherence.patterns.processing.internal.SubmissionContent;
import com.oracle.coherence.patterns.processing.internal.SubmissionKey;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import java.util.NoSuchElementException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DefaultPendingSubmission
implements PendingSubmission {
    private final long creationTime;
    private long dispatchDelay;
    private final SubmissionConfiguration requestData;
    private final Identifier resultIdentifier;
    private final SubmissionKey submissionKey;
    private TimeUnit timeUnit;
    private transient Object payLoad;

    public DefaultPendingSubmission(SubmissionKey submissionKey, Identifier resultIdentifier, SubmissionConfiguration requestData, long delay) {
        this.submissionKey = submissionKey;
        this.requestData = requestData;
        this.resultIdentifier = resultIdentifier;
        this.dispatchDelay = delay;
        this.timeUnit = TimeUnit.MILLISECONDS;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getDelay(TimeUnit oUnit) {
        return oUnit.convert(this.creationTime + this.dispatchDelay - System.currentTimeMillis(), this.timeUnit);
    }

    @Override
    public Object getPayload() {
        if (this.payLoad == null) {
            NamedCache cache = CacheFactory.getCache((String)"coherence.patterns.processing.submissions");
            Submission ct = (Submission)cache.get((Object)this.getSubmissionKey());
            if (ct != null) {
                SubmissionContent sct = ct.getContent();
                if (sct != null) {
                    this.payLoad = sct.getPayload();
                }
            } else {
                throw new NoSuchElementException("No Submission cache entry for " + this.getSubmissionKey());
            }
        }
        return this.payLoad;
    }

    @Override
    public SubmissionConfiguration getSubmissionConfiguration() {
        return this.requestData;
    }

    @Override
    public Identifier getResultIdentifier() {
        return this.resultIdentifier;
    }

    @Override
    public SubmissionKey getSubmissionKey() {
        return this.submissionKey;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public int compareTo(Delayed o) {
        PendingSubmission otherSubmission = (PendingSubmission)o;
        return (int)(this.creationTime + this.dispatchDelay - (otherSubmission.getCreationTime() + otherSubmission.getDelay(TimeUnit.MILLISECONDS)));
    }

    @Override
    public boolean equals(Object oOther) {
        if (this == oOther) {
            return true;
        }
        if (oOther == null) {
            return false;
        }
        if (this.getClass() != oOther.getClass()) {
            return false;
        }
        DefaultPendingSubmission otherSubmission = (DefaultPendingSubmission)oOther;
        return !(this.submissionKey == null ? otherSubmission.submissionKey != null : !this.submissionKey.equals(otherSubmission.submissionKey));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int nResult = 1;
        nResult = 31 * nResult + (this.submissionKey == null ? 0 : this.submissionKey.hashCode());
        return nResult;
    }

    public String toString() {
        return "DefaultPendingSubmission [creationTime=" + this.creationTime + ", dispatchDelay=" + this.dispatchDelay + ", " + (this.requestData != null ? "requestData=" + this.requestData + ", " : "") + (this.resultIdentifier != null ? "resultIdentifier=" + this.resultIdentifier + ", " : "") + (this.submissionKey != null ? "submissionKey=" + this.submissionKey + ", " : "") + (this.timeUnit != null ? "timeUnit=" + (Object)((Object)this.timeUnit) : "") + "]";
    }

    public void setDelay(long dispatchDelay) {
        this.dispatchDelay = dispatchDelay;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

