/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.patterns.processing.internal.Environment;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class DefaultEnvironment
implements Environment {
    private static final Logger logger = Logger.getLogger(Environment.class.getName());
    private ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> resourcesByClass = new ConcurrentHashMap();

    @Override
    public <R> R getResource(Class<R> clazz) {
        return this.getResource(clazz, "");
    }

    @Override
    public <R> R getResource(Class<R> clazz, String name) {
        if (this.resourcesByClass.containsKey(clazz)) {
            return (R)this.resourcesByClass.get(clazz).get(name);
        }
        return null;
    }

    @Override
    public <R> R registerResource(Class<R> clazz, Object resource) {
        return this.registerResource(clazz, "", resource);
    }

    @Override
    public <R> R registerResource(Class<R> clazz, String name, Object resource) {
        Object oldRes;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Attempted to registerResource(%s, null) with a null name.  null names are not supported", clazz));
        }
        ConcurrentHashMap<String, Object> resourcesByName = this.resourcesByClass.get(clazz);
        if (resourcesByName == null) {
            resourcesByName = new ConcurrentHashMap();
            this.resourcesByClass.put(clazz, resourcesByName);
        }
        if ((oldRes = resourcesByName.get(name)) == null) {
            oldRes = resource;
            resourcesByName.put(name, resource);
        } else {
            logger.warning(String.format("Environment resource [%s] of type [%s] is already registered as [%s].  Skipping requested registration.", name, clazz, resource));
        }
        return (R)oldRes;
    }
}

