/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.internal;

import com.oracle.coherence.patterns.processing.dispatchers.Dispatcher;
import com.oracle.coherence.patterns.processing.friends.DispatcherManager;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalPut;
import com.tangosol.util.processor.ConditionalRemove;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDispatcherManager
implements DispatcherManager {
    public static final String CACHENAME = "coherence.patterns.processing.dispatchers";
    private NamedCache dispatcherCache;
    private ConfigurableCacheFactory ccFactory;
    private volatile boolean started = false;
    private ConcurrentHashMap<Integer, Dispatcher> toBeRegistered;

    public DefaultDispatcherManager(ConfigurableCacheFactory ccFactory) {
        this.ccFactory = ccFactory;
        this.toBeRegistered = new ConcurrentHashMap();
    }

    public void onDependenciesSatisfied(Environment environment) {
        this.dispatcherCache = this.ccFactory.ensureCache(CACHENAME, null);
        this.started = true;
        for (Integer key : this.toBeRegistered.keySet()) {
            this.registerDispatcher(key, this.toBeRegistered.get(key));
        }
    }

    @Override
    public void registerDispatcher(int priority, Dispatcher dispatcher) {
        if (!this.started) {
            this.toBeRegistered.put(priority, dispatcher);
        } else {
            NotFilter filter = new NotFilter((Filter)PresentFilter.INSTANCE);
            this.dispatcherCache.invoke((Object)priority, (InvocableMap.EntryProcessor)new ConditionalPut((Filter)filter, (Object)dispatcher));
        }
    }

    @Override
    public void unregisterDispatcher(int priority, Dispatcher dispatcher) {
        this.dispatcherCache.invoke((Object)priority, (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)PresentFilter.INSTANCE));
    }
}

