/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.dispatchers.task;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.oracle.coherence.patterns.processing.dispatchers.task.TaskDispatchPolicy;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.task.Task;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RoundRobinTaskDispatchPolicy
implements TaskDispatchPolicy,
ExternalizableLite,
PortableObject {
    private transient int roundRobinIndex;

    @Override
    public Map<TaskProcessorMediatorKey, TaskProcessorMediator> selectTaskProcessorSet(Task task, SubmissionConfiguration submissionConfiguration, Map<TaskProcessorMediatorKey, TaskProcessorMediator> taskProcessorMediators, ConcurrentHashMap<Identifier, TaskProcessorDefinition> taskProcessorDefinitions) {
        if (taskProcessorMediators.isEmpty()) {
            return taskProcessorMediators;
        }
        int index = this.generateNext(taskProcessorMediators.size());
        TaskProcessorMediatorKey selectedKey = null;
        TaskProcessorMediator selectedMediator = null;
        int collectionCounter = 0;
        Iterator<Map.Entry<TaskProcessorMediatorKey, TaskProcessorMediator>> iter = taskProcessorMediators.entrySet().iterator();
        while (iter.hasNext()) {
            if (collectionCounter == index) {
                Map.Entry<TaskProcessorMediatorKey, TaskProcessorMediator> entry = iter.next();
                selectedKey = entry.getKey();
                selectedMediator = entry.getValue();
            } else {
                iter.next();
            }
            ++collectionCounter;
        }
        return Collections.singletonMap(selectedKey, selectedMediator);
    }

    private int generateNext(int upperBoundary) {
        ++this.roundRobinIndex;
        if (this.roundRobinIndex >= upperBoundary) {
            this.roundRobinIndex = 0;
        }
        return this.roundRobinIndex;
    }

    public void readExternal(DataInput in) throws IOException {
        this.roundRobinIndex = 0;
    }

    public void writeExternal(DataOutput out) throws IOException {
    }

    public void readExternal(PofReader reader) throws IOException {
        this.roundRobinIndex = 0;
    }

    public void writeExternal(PofWriter writer) throws IOException {
    }
}

