/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.dispatchers.task;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.oracle.coherence.patterns.processing.dispatchers.task.TaskDispatchPolicy;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.task.Task;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class RandomTaskDispatchPolicy
implements TaskDispatchPolicy,
ExternalizableLite,
PortableObject {
    private transient Random generator = new Random(System.currentTimeMillis());

    @Override
    public Map<TaskProcessorMediatorKey, TaskProcessorMediator> selectTaskProcessorSet(Task task, SubmissionConfiguration submissionConfiguration, Map<TaskProcessorMediatorKey, TaskProcessorMediator> taskProcessorMediators, ConcurrentHashMap<Identifier, TaskProcessorDefinition> taskProcessorDefinitions) {
        int randomTaskProcessor = this.generator.nextInt(taskProcessorMediators.size());
        Map.Entry<TaskProcessorMediatorKey, TaskProcessorMediator> selectedEntry = null;
        int collectionCounter = 0;
        Iterator<Map.Entry<TaskProcessorMediatorKey, TaskProcessorMediator>> iter = taskProcessorMediators.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<TaskProcessorMediatorKey, TaskProcessorMediator> entry = iter.next();
            if (collectionCounter == randomTaskProcessor) {
                selectedEntry = entry;
                break;
            }
            iter.next();
            ++collectionCounter;
        }
        return Collections.singletonMap(selectedEntry.getKey(), selectedEntry.getValue());
    }

    public void readExternal(DataInput in) throws IOException {
        this.generator = new Random(System.currentTimeMillis());
    }

    public void writeExternal(DataOutput out) throws IOException {
    }

    public void readExternal(PofReader reader) throws IOException {
        this.generator = new Random(System.currentTimeMillis());
    }

    public void writeExternal(PofWriter writer) throws IOException {
    }
}

