/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.dispatchers.task;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.oracle.coherence.patterns.processing.dispatchers.task.TaskDispatchPolicy;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.task.Task;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttributeMatchTaskDispatchPolicy
implements TaskDispatchPolicy,
ExternalizableLite,
PortableObject {
    private static Logger logger = Logger.getLogger(AttributeMatchTaskDispatchPolicy.class.getName());

    @Override
    public Map<TaskProcessorMediatorKey, TaskProcessorMediator> selectTaskProcessorSet(Task task, SubmissionConfiguration submissionConfiguration, Map<TaskProcessorMediatorKey, TaskProcessorMediator> taskProcessorMediators, ConcurrentHashMap<Identifier, TaskProcessorDefinition> taskProcessorDefinitions) {
        HashMap<TaskProcessorMediatorKey, TaskProcessorMediator> result = new HashMap<TaskProcessorMediatorKey, TaskProcessorMediator>();
        Iterator<Map.Entry<TaskProcessorMediatorKey, TaskProcessorMediator>> iter = taskProcessorMediators.entrySet().iterator();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Selecting TaskProcessor for {0}", task);
        }
        while (iter.hasNext()) {
            Map.Entry<TaskProcessorMediatorKey, TaskProcessorMediator> entry = iter.next();
            TaskProcessorMediator mediator = entry.getValue();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Matching attributes for TaskProcessor {0}, task {1}", new Object[]{mediator, task});
            }
            Boolean matches = true;
            Map confMap = submissionConfiguration.getConfigurationDataMap();
            Map tpmMap = mediator.getAttributeMap();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Configuration Map:{0}", new Object[]{confMap});
                logger.log(Level.FINER, "Attribute Map:{0}", new Object[]{tpmMap});
            }
            Iterator confMapiter = confMap.entrySet().iterator();
            while (confMapiter.hasNext()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Matching attributes for TaskProcessor {0}, task {1}", new Object[]{mediator, task});
                }
                Map.Entry confMapEntry = confMapiter.next();
                Object attrkey = confMapEntry.getKey();
                Object confValue = confMapEntry.getValue();
                if (confValue == null) continue;
                Object tpmValue = tpmMap.get(attrkey);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Comparing submission attribute {0}, value: {1}, TaskProcessor attribute value:{2}", new Object[]{attrkey, confValue, tpmValue});
                }
                if (tpmValue != null) {
                    if (confValue.equals(tpmValue)) {
                        matches = true;
                        continue;
                    }
                    matches = false;
                    continue;
                }
                matches = false;
            }
            if (!matches.booleanValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void readExternal(DataInput in) throws IOException {
    }

    public void writeExternal(DataOutput out) throws IOException {
    }

    public void readExternal(PofReader reader) throws IOException {
    }

    public void writeExternal(PofWriter writer) throws IOException {
    }
}

