/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.dispatchers.logging;

import com.oracle.coherence.patterns.processing.dispatchers.AbstractDispatcher;
import com.oracle.coherence.patterns.processing.dispatchers.DispatchController;
import com.oracle.coherence.patterns.processing.dispatchers.DispatchOutcome;
import com.oracle.coherence.patterns.processing.dispatchers.PendingSubmission;
import com.oracle.coherence.patterns.processing.dispatchers.logging.LoggingDispatcherMBean;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingDispatcher
extends AbstractDispatcher
implements ExternalizableLite,
PortableObject,
LoggingDispatcherMBean {
    private static Logger logger = Logger.getLogger(LoggingDispatcher.class.getName());
    private Level logLevel;
    private int noOfferedSubmissions;
    private Environment environment;

    public LoggingDispatcher() {
        this.logLevel = Level.INFO;
    }

    public LoggingDispatcher(Level logLevel) {
        this.logLevel = logLevel;
    }

    public LoggingDispatcher(Environment environment, String name) {
        super(name);
        this.environment = environment;
        this.logLevel = Level.INFO;
    }

    @Override
    public DispatchOutcome dispatch(PendingSubmission oPendingProcess) {
        ++this.noOfferedSubmissions;
        if (logger.isLoggable(this.logLevel)) {
            logger.log(this.logLevel, "[LoggingDispatcher] SubmissionId={0}, Payload={1}", new Object[]{oPendingProcess.getSubmissionKey(), oPendingProcess.getPayload()});
        }
        return DispatchOutcome.CONTINUE;
    }

    @Override
    public void onShutdown(DispatchController dispatchController) {
        super.onShutdown(dispatchController);
    }

    @Override
    public void onStartup(DispatchController dispatchController) {
        super.onStartup(dispatchController);
        this.registerMBean();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.logLevel = Level.parse(ExternalizableHelper.readUTF((DataInput)in));
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.logLevel.getName());
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        super.readExternal(reader);
        this.logLevel = Level.parse(reader.readString(100));
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        super.writeExternal(writer);
        writer.writeString(100, this.logLevel.getName());
    }

    @Override
    public String getDispatcherName() {
        return this.getName();
    }

    @Override
    public int getSubmissionsAccepted() {
        return 0;
    }

    @Override
    public int getSubmissionsOffered() {
        return this.noOfferedSubmissions;
    }
}

