/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.dispatchers;

import java.util.concurrent.TimeUnit;

public interface DispatchOutcome {
    public static final DispatchOutcome ACCEPTED = new Accepted();
    public static final DispatchOutcome REJECTED = new Rejected();
    public static final DispatchOutcome CONTINUE = new RetryLater();

    public static final class RetryLater
    implements DispatchOutcome {
        private long delay;
        private TimeUnit timeUnit;

        public RetryLater() {
            this.delay = 0L;
            this.timeUnit = TimeUnit.SECONDS;
        }

        public RetryLater(long lDelay, TimeUnit oTimeUnit) {
            this.delay = lDelay;
            this.timeUnit = oTimeUnit;
        }

        public long getDelay() {
            return this.delay;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }
    }

    public static final class Rejected
    implements DispatchOutcome {
    }

    public static final class Accepted
    implements DispatchOutcome {
    }

    public static final class Abort
    implements DispatchOutcome {
        private String m_sRationale;
        private Object result;

        public Abort(String sRationale, Object oResult) {
            this.m_sRationale = sRationale;
            this.result = oResult;
        }

        public String getRationale() {
            return this.m_sRationale;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

