/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.dispatchers;

import com.oracle.coherence.patterns.processing.dispatchers.DispatchController;
import com.oracle.coherence.patterns.processing.dispatchers.Dispatcher;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.Registry;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDispatcher
implements Dispatcher,
PortableObject,
ExternalizableLite {
    private static Logger logger = Logger.getLogger(AbstractDispatcher.class.getName());
    private DispatchController dispatchController;
    private String name;
    private String mBeanName;

    public AbstractDispatcher() {
    }

    public AbstractDispatcher(String name) {
        this.name = name;
    }

    protected void setMBeanName(String mBeanName) {
        this.mBeanName = mBeanName;
    }

    protected String getMBeanName() {
        return this.mBeanName;
    }

    protected void registerMBean() {
        Registry registry = CacheFactory.ensureCluster().getManagement();
        if (registry != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Registering JMX management extensions for Dispatcher {0}", this.getName());
            }
            this.setMBeanName(registry.ensureGlobalName(String.format("type=ProcessingPattern,subType=Dispatcher,id=%s", this.getClass().getSimpleName() + ":" + this.getName())));
            registry.register(this.getMBeanName(), (Object)this);
        }
    }

    protected void unregisterMBean() {
        Registry registry = CacheFactory.ensureCluster().getManagement();
        if (registry != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Unregistering JMX management extensions for Dispatcher {0}", this.getName());
            }
            registry.unregister(this.getMBeanName());
        }
    }

    public DispatchController getDispatchController() {
        return this.dispatchController;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.dispatchController != null;
    }

    @Override
    public void onShutdown(DispatchController dispatchController) {
        this.dispatchController = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Shutting down dispatcher {0}", this.getName());
        }
    }

    @Override
    public void onStartup(DispatchController dispatchController) {
        this.dispatchController = dispatchController;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Starting dispatcher {0}", this.getName());
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.name = ExternalizableHelper.readSafeUTF((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.name);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.name = reader.readString(0);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(0, this.name);
    }
}

