/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.config.xml.processor;

import com.oracle.coherence.patterns.processing.config.builder.DispatcherBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.XmlElement;
import java.util.ArrayList;
import java.util.List;

@XmlSimpleName(value="dispatchers")
public class DispatchersProcessor
implements ElementProcessor<List<DispatcherBuilder>> {
    public List<DispatcherBuilder> process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        ArrayList<DispatcherBuilder> listBldrs = new ArrayList<DispatcherBuilder>();
        for (XmlElement elementChild : element.getElementList()) {
            Object oValue = context.processElement(elementChild);
            if (oValue instanceof DispatcherBuilder) {
                listBldrs.add((DispatcherBuilder)oValue);
                continue;
            }
            throw new ConfigurationException(String.format("Invalid dispatcher definition [%s] in [%s]", elementChild, element), "Please ensure the dispatcher is correctly defined");
        }
        return listBldrs;
    }
}

