/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.config.xml.processor;

import com.oracle.coherence.patterns.processing.config.builder.CompositePolicyBuilder;
import com.oracle.coherence.patterns.processing.dispatchers.task.TaskDispatchPolicy;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.XmlElement;

@XmlSimpleName(value="composite-policy")
public class CompositePolicyProcessor
implements ElementProcessor<CompositePolicyBuilder> {
    public CompositePolicyBuilder process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        CompositePolicyBuilder bldr = new CompositePolicyBuilder();
        for (XmlElement elementChild : element.getElementList()) {
            if (elementChild.getName().endsWith("attribute-match-policy")) {
                bldr.setAttributeMatchPolicy();
                continue;
            }
            if (elementChild.getName().endsWith("composite-policy")) {
                Object oValue = context.processElement(elementChild);
                bldr.setPolicy((TaskDispatchPolicy)oValue);
                continue;
            }
            if (elementChild.getName().endsWith("round-robin-policy")) {
                bldr.setRoundRobinPolicy();
                continue;
            }
            if (elementChild.getName().endsWith("random-policy")) {
                bldr.setRandomPolicy();
                continue;
            }
            throw new ConfigurationException(String.format("Invalid dispatcher definition [%s] in [%s]", elementChild, element), "Please ensure the dispatcher is correctly defined");
        }
        return bldr;
    }
}

