/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.config.builder;

import com.oracle.coherence.common.identifiers.StringBasedIdentifier;
import com.oracle.coherence.patterns.processing.config.builder.AttributeConfig;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.task.DefaultTaskProcessorDefinition;
import com.oracle.coherence.patterns.processing.task.TaskProcessor;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.oracle.coherence.patterns.processing.task.TaskProcessorType;
import com.oracle.coherence.patterns.processing.taskprocessor.DefaultTaskProcessor;
import com.tangosol.coherence.config.builder.BuilderCustomization;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.util.Base;
import java.util.HashMap;
import java.util.Map;

public class TaskProcessorDefinitionBuilder
implements BuilderCustomization<TaskProcessor> {
    private volatile ParameterizedBuilder<TaskProcessor> m_bldrCustom;
    private String m_sId;
    private String m_sName;
    private TaskProcessorType m_type;
    private DefaultTaskProcessorConfig m_taskProcessorConfig = new DefaultTaskProcessorConfig();
    private final Map<String, String> m_mapAttributes = new HashMap<String, String>();

    public TaskProcessorDefinition realize(Environment env) {
        TaskProcessor taskProcessor = this.m_bldrCustom == null ? new DefaultTaskProcessor(this.m_taskProcessorConfig.m_sId, this.m_taskProcessorConfig.m_cThreads) : (TaskProcessor)this.m_bldrCustom.realize((ParameterResolver)new NullParameterResolver(), Base.getContextClassLoader(), null);
        return new DefaultTaskProcessorDefinition(StringBasedIdentifier.newInstance((String)this.m_sId), this.m_sName, this.m_type, taskProcessor, this.m_mapAttributes);
    }

    @Injectable(value="displayname")
    public void setDisplayName(String sName) {
        this.m_sName = sName;
    }

    @Injectable
    public void setId(String sId) {
        this.m_sId = sId;
    }

    @Injectable
    public void setType(String sType) {
        if (sType.equalsIgnoreCase("GRID")) {
            this.m_type = TaskProcessorType.GRID;
        } else if (sType.equalsIgnoreCase("SINGLE")) {
            this.m_type = TaskProcessorType.SINGLE;
        } else {
            throw new ConfigurationException(String.format("Invalid TaskProcessorType %s", sType), String.format("Specify either 'GRID' or 'SINGLE", new Object[0]));
        }
    }

    @Injectable(value="default-taskprocessor")
    public void setDefaultTaskProcessorConfig(DefaultTaskProcessorConfig config) {
        this.m_taskProcessorConfig = config;
    }

    @Injectable
    public void setAttribute(AttributeConfig attributeConfig) {
        this.m_mapAttributes.put(attributeConfig.getName(), attributeConfig.getsAttribute());
    }

    public ParameterizedBuilder<TaskProcessor> getCustomBuilder() {
        return this.m_bldrCustom;
    }

    public void setCustomBuilder(ParameterizedBuilder<TaskProcessor> bldr) {
        this.m_bldrCustom = bldr;
    }

    public static class DefaultTaskProcessorConfig {
        private String m_sId = "Default";
        private int m_cThreads = 1;

        @Injectable
        public void setId(String sId) {
            this.m_sId = sId;
        }

        @Injectable(value="threadpoolsize")
        public void setThreadPoolSize(int cThreads) {
            this.m_cThreads = cThreads;
        }
    }
}

