/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.config.builder;

import com.oracle.coherence.patterns.processing.config.ProcessingPatternConfig;
import com.oracle.coherence.patterns.processing.config.builder.DispatcherBuilder;
import com.oracle.coherence.patterns.processing.config.builder.TaskProcessorDefinitionBuilder;
import com.oracle.coherence.patterns.processing.dispatchers.Dispatcher;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.ProcessingPattern;
import com.oracle.coherence.patterns.processing.task.TaskProcessorDefinition;
import com.tangosol.config.annotation.Injectable;
import java.util.ArrayList;
import java.util.List;

public class ProcessingPatternConfigBuilder {
    private volatile List<DispatcherBuilder> m_listDispatchBuilders = new ArrayList<DispatcherBuilder>();
    private volatile List<TaskProcessorDefinitionBuilder> m_listTaskProcessBuilders = new ArrayList<TaskProcessorDefinitionBuilder>();

    public ProcessingPatternConfig realize(Environment env) {
        ProcessingPattern.createClientSideObjects(env);
        ArrayList<Dispatcher> listDispatchers = new ArrayList<Dispatcher>();
        ArrayList<TaskProcessorDefinition> listProcessorDefinitions = new ArrayList<TaskProcessorDefinition>();
        for (DispatcherBuilder dispatcherBuilder : this.m_listDispatchBuilders) {
            listDispatchers.add(dispatcherBuilder.realize(env));
        }
        for (TaskProcessorDefinitionBuilder taskProcessorDefinitionBuilder : this.m_listTaskProcessBuilders) {
            listProcessorDefinitions.add(taskProcessorDefinitionBuilder.realize(env));
        }
        return new ProcessingPatternConfig(listDispatchers, listProcessorDefinitions);
    }

    @Injectable(value="dispatchers")
    public void setDispatchers(List<DispatcherBuilder> listBldrs) {
        this.m_listDispatchBuilders = listBldrs;
    }

    @Injectable(value="taskprocessors")
    public void setTaskProcessors(List<TaskProcessorDefinitionBuilder> listBldrs) {
        this.m_listTaskProcessBuilders = listBldrs;
    }
}

