/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.config.builder;

import com.oracle.coherence.patterns.processing.dispatchers.task.AttributeMatchTaskDispatchPolicy;
import com.oracle.coherence.patterns.processing.dispatchers.task.CompositeTaskDispatchPolicy;
import com.oracle.coherence.patterns.processing.dispatchers.task.RandomTaskDispatchPolicy;
import com.oracle.coherence.patterns.processing.dispatchers.task.RoundRobinTaskDispatchPolicy;
import com.oracle.coherence.patterns.processing.dispatchers.task.TaskDispatchPolicy;
import java.util.ArrayList;
import java.util.List;

public class CompositePolicyBuilder {
    private List<TaskDispatchPolicy> m_policies = new ArrayList<TaskDispatchPolicy>();

    public TaskDispatchPolicy realize() {
        if (this.m_policies.size() != 2) {
            throw new IllegalStateException("The composite policy must have 2 inner policies");
        }
        return new CompositeTaskDispatchPolicy(this.m_policies.get(0), this.m_policies.get(1));
    }

    public void setAttributeMatchPolicy() {
        this.m_policies.add(new AttributeMatchTaskDispatchPolicy());
    }

    public void setRoundRobinPolicy() {
        this.m_policies.add(new RoundRobinTaskDispatchPolicy());
    }

    public void setRandomPolicy() {
        this.m_policies.add(new RandomTaskDispatchPolicy());
    }

    public void setPolicy(TaskDispatchPolicy policy) {
        this.m_policies.add(policy);
    }
}

