/*
 * File: Command.java
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * The contents of this file are subject to the terms and conditions of 
 * the Common Development and Distribution License 1.0 (the "License").
 *
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the License by consulting the LICENSE.txt file
 * distributed with this file, or by consulting https://oss.oracle.com/licenses/CDDL
 *
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file LICENSE.txt.
 *
 * MODIFICATIONS:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 */

package com.oracle.coherence.patterns.command;

import com.oracle.coherence.patterns.command.internal.CommandExecutor;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PortableObject;

import java.io.Serializable;

/**
 * A {@link Command} represents some action (together with required state)
 * that is to be asynchronously executed against a {@link Context}.
 * <p>
 * As {@link Command}s are cached objects (ie: placed in Coherence caches),
 * they need to at least implement {@link Serializable}, or better still, implement
 * {@link ExternalizableLite} or {@link PortableObject}.
 * <p>
 * To submit a {@link Command} for execution against a {@link Context} you
 * should use a {@link CommandSubmitter}.
 * <p>
 * Copyright (c) 2008. All Rights Reserved. Oracle Corporation.<br>
 * Oracle is a registered trademark of Oracle Corporation and/or its affiliates.
 *
 * @see Context
 * @see CommandSubmitter
 * @see CommandExecutor (internal)
 *
 * @author Brian Oliver
 */
public interface Command<C extends Context>
{
    /**
     * Executes the {@link Command} using the provided
     * {@link ExecutionEnvironment}.
     *
     * @param executionEnvironment The environment in which the {@link Command}
     *                             is being executed.
     */
    public abstract void execute(ExecutionEnvironment<C> executionEnvironment);
}
