/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.common.ticketing.Ticket;
import com.oracle.coherence.patterns.command.Context;
import com.oracle.coherence.patterns.command.internal.ContextWrapper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UpdateContextProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private long contextVersion;
    private Context context;
    private Ticket lastExecutedTicket;
    private long executionDuration;
    private long waitingDuration;

    public UpdateContextProcessor() {
    }

    public UpdateContextProcessor(long contextVersion, Context context, Ticket lastExecutedTicket, long executionDuration, long waitingDuration) {
        this.contextVersion = contextVersion;
        this.context = context;
        this.lastExecutedTicket = lastExecutedTicket;
        this.executionDuration = executionDuration;
        this.waitingDuration = waitingDuration;
    }

    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent()) {
            ContextWrapper contextWrapper = (ContextWrapper)entry.getValue();
            if (contextWrapper.getContextVersion() == this.contextVersion) {
                contextWrapper.updateExecutionInformation(this.lastExecutedTicket, this.executionDuration, this.waitingDuration);
                if (this.context != null) {
                    contextWrapper.setContext(this.context);
                }
                entry.setValue((Object)contextWrapper);
                return true;
            }
            return false;
        }
        return false;
    }

    public void readExternal(DataInput in) throws IOException {
        this.contextVersion = ExternalizableHelper.readLong((DataInput)in);
        this.context = (Context)ExternalizableHelper.readObject((DataInput)in);
        this.lastExecutedTicket = (Ticket)ExternalizableHelper.readExternalizableLite((DataInput)in);
        this.executionDuration = ExternalizableHelper.readLong((DataInput)in);
        this.waitingDuration = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.contextVersion);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.context);
        ExternalizableHelper.writeExternalizableLite((DataOutput)out, (ExternalizableLite)this.lastExecutedTicket);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.executionDuration);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.waitingDuration);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.contextVersion = reader.readLong(0);
        this.context = (Context)reader.readObject(1);
        this.lastExecutedTicket = (Ticket)reader.readObject(2);
        this.executionDuration = reader.readLong(3);
        this.waitingDuration = reader.readLong(4);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.contextVersion);
        writer.writeObject(1, (Object)this.context);
        writer.writeObject(2, (Object)this.lastExecutedTicket);
        writer.writeLong(3, this.executionDuration);
        writer.writeLong(4, this.waitingDuration);
    }
}

