/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.command.internal.CommandExecutionRequest;
import com.oracle.coherence.patterns.command.internal.CommandExecutor;
import com.oracle.coherence.patterns.command.internal.CommandExecutorManager;
import com.oracle.coherence.patterns.command.internal.SubmissionOutcome;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SubmitCommandExecutionRequestProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private CommandExecutionRequest commandExecutionRequest;
    private boolean acceptCommandIfContextDoesNotExist;

    public SubmitCommandExecutionRequestProcessor() {
    }

    public SubmitCommandExecutionRequestProcessor(CommandExecutionRequest commandExecutionRequest, boolean acceptIfContextDoesNotExist) {
        this.commandExecutionRequest = commandExecutionRequest;
        this.acceptCommandIfContextDoesNotExist = acceptIfContextDoesNotExist;
    }

    public Object process(InvocableMap.Entry entry) {
        CommandExecutor commandExecutor;
        Identifier contextIdentifier = this.commandExecutionRequest.getContextIdentifier();
        if (this.acceptCommandIfContextDoesNotExist) {
            BackingMapManagerContext backingMapManagerContext = ((DistributedCacheService)CacheFactory.getService((String)"DistributedCacheForCommandPattern")).getBackingMapManager().getContext();
            commandExecutor = CommandExecutorManager.ensureCommandExecutor(contextIdentifier, backingMapManagerContext);
        } else {
            commandExecutor = CommandExecutorManager.getCommandExecutor(contextIdentifier);
        }
        if (commandExecutor == null && !this.acceptCommandIfContextDoesNotExist) {
            return new SubmissionOutcome.UnknownContext();
        }
        return commandExecutor.acceptCommandExecutionRequest(this.commandExecutionRequest);
    }

    public void readExternal(DataInput in) throws IOException {
        this.commandExecutionRequest = (CommandExecutionRequest)ExternalizableHelper.readExternalizableLite((DataInput)in);
        this.acceptCommandIfContextDoesNotExist = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeExternalizableLite((DataOutput)out, (ExternalizableLite)this.commandExecutionRequest);
        out.writeBoolean(this.acceptCommandIfContextDoesNotExist);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.commandExecutionRequest = (CommandExecutionRequest)reader.readObject(0);
        this.acceptCommandIfContextDoesNotExist = reader.readBoolean(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.commandExecutionRequest);
        writer.writeBoolean(1, this.acceptCommandIfContextDoesNotExist);
    }
}

