/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.ticketing.Ticket;
import com.oracle.coherence.patterns.command.Context;
import com.oracle.coherence.patterns.command.ContextConfiguration;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ContextWrapper
implements ExternalizableLite,
PortableObject {
    public static final String CACHENAME = "coherence.commandpattern.contexts";
    private Identifier contextIdentifier;
    private Context context;
    private ContextConfiguration contextConfiguration;
    private long contextVersion;
    private Ticket lastExecutedTicket;
    private long totalCommandsExecuted;
    private long totalCommandExecutionDuration;
    private long totalCommandExecutionWaitingDuration;

    public ContextWrapper() {
    }

    public ContextWrapper(Identifier contextIdentifier, Context context, ContextConfiguration contextConfiguration) {
        this.contextIdentifier = contextIdentifier;
        this.context = context;
        this.contextConfiguration = contextConfiguration;
        this.contextVersion = 0L;
        this.lastExecutedTicket = Ticket.NONE;
        this.totalCommandsExecuted = 0L;
        this.totalCommandExecutionDuration = 0L;
        this.totalCommandExecutionWaitingDuration = 0L;
    }

    public Identifier getContentIdentifier() {
        return this.contextIdentifier;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public ContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public long getContextVersion() {
        return this.contextVersion;
    }

    public long nextVersion() {
        return ++this.contextVersion;
    }

    public Ticket getLastExecutedTicket() {
        return this.lastExecutedTicket;
    }

    public long getTotalCommandsExecuted() {
        return this.totalCommandsExecuted;
    }

    public long getTotalCommandExecutionDuration() {
        return this.totalCommandExecutionDuration;
    }

    public long getTotalCommandExecutionWaitingDuration() {
        return this.totalCommandExecutionWaitingDuration;
    }

    public void updateExecutionInformation(Ticket ticket, long executionDuration, long waitingDuration) {
        this.lastExecutedTicket = ticket;
        ++this.totalCommandsExecuted;
        this.totalCommandExecutionDuration += executionDuration;
        this.totalCommandExecutionWaitingDuration += waitingDuration;
    }

    public void readExternal(DataInput in) throws IOException {
        this.contextIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
        this.context = (Context)ExternalizableHelper.readObject((DataInput)in);
        this.contextConfiguration = (ContextConfiguration)ExternalizableHelper.readObject((DataInput)in);
        this.contextVersion = ExternalizableHelper.readLong((DataInput)in);
        this.lastExecutedTicket = (Ticket)ExternalizableHelper.readExternalizableLite((DataInput)in);
        this.totalCommandsExecuted = ExternalizableHelper.readLong((DataInput)in);
        this.totalCommandExecutionDuration = ExternalizableHelper.readLong((DataInput)in);
        this.totalCommandExecutionWaitingDuration = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.contextIdentifier);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.context);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.contextConfiguration);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.contextVersion);
        ExternalizableHelper.writeExternalizableLite((DataOutput)out, (ExternalizableLite)this.lastExecutedTicket);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.totalCommandsExecuted);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.totalCommandExecutionDuration);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.totalCommandExecutionWaitingDuration);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.contextIdentifier = (Identifier)reader.readObject(0);
        this.context = (Context)reader.readObject(1);
        this.contextConfiguration = (ContextConfiguration)reader.readObject(2);
        this.contextVersion = reader.readLong(3);
        this.lastExecutedTicket = (Ticket)reader.readObject(4);
        this.totalCommandsExecuted = reader.readLong(5);
        this.totalCommandExecutionDuration = reader.readLong(6);
        this.totalCommandExecutionWaitingDuration = reader.readLong(7);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.contextIdentifier);
        writer.writeObject(1, (Object)this.context);
        writer.writeObject(2, (Object)this.contextConfiguration);
        writer.writeLong(3, this.contextVersion);
        writer.writeObject(4, (Object)this.lastExecutedTicket);
        writer.writeLong(5, this.totalCommandsExecuted);
        writer.writeLong(6, this.totalCommandExecutionDuration);
        writer.writeLong(7, this.totalCommandExecutionWaitingDuration);
    }

    public String toString() {
        return String.format("ContextWrapper{contextIdentifier=%s, context=%s, contextConfiguration=%s, contextVersion=%d, lastExecutedTicket=%s, totalCommandsExecuted=%d, totalCommandExecutionDuration=%d, totalCommandExecutionWaitingDuration=%d}", this.contextIdentifier, this.context, this.contextConfiguration, this.contextVersion, this.lastExecutedTicket, this.totalCommandsExecuted, this.totalCommandExecutionDuration, this.totalCommandExecutionWaitingDuration);
    }
}

