/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.common.backingmaplisteners.AbstractMultiplexingBackingMapListener;
import com.oracle.coherence.common.backingmaplisteners.Cause;
import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.patterns.command.internal.CommandExecutor;
import com.oracle.coherence.patterns.command.internal.CommandExecutorManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.MapEvent;
import java.util.concurrent.TimeUnit;

public class ContextBackingMapListener
extends AbstractMultiplexingBackingMapListener {
    public ContextBackingMapListener(BackingMapManagerContext backingMapManagerContext) {
        super(backingMapManagerContext);
    }

    public void onBackingMapEvent(MapEvent mapEvent, Cause cause) {
        if (mapEvent.getId() == 1) {
            Identifier contextIdentifier = (Identifier)mapEvent.getKey();
            if (Logger.isEnabled((int)5)) {
                Logger.log((int)5, (String)"Context %s has been inserted into this member", (Object[])new Object[]{contextIdentifier});
            }
            final CommandExecutor commandExecutor = CommandExecutorManager.ensureCommandExecutor(contextIdentifier, this.getContext());
            if (Logger.isEnabled((int)5)) {
                Logger.log((int)5, (String)"Scheduling ContextExecutor for %s to start", (Object[])new Object[]{contextIdentifier});
            }
            CommandExecutorManager.schedule(new Runnable(){

                @Override
                public void run() {
                    commandExecutor.start();
                }
            }, 0L, TimeUnit.SECONDS);
        } else if (mapEvent.getId() == 3) {
            CommandExecutor commandExecutor;
            Identifier contextIdentifier = (Identifier)mapEvent.getKey();
            if (Logger.isEnabled((int)5)) {
                Logger.log((int)5, (String)"Context %s has been removed from this member", (Object[])new Object[]{contextIdentifier});
            }
            if ((commandExecutor = CommandExecutorManager.getCommandExecutor(contextIdentifier)) != null) {
                commandExecutor.stop();
            }
        }
    }
}

