/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.common.threading.ExecutorServiceFactory;
import com.oracle.coherence.common.threading.ThreadFactories;
import com.oracle.coherence.patterns.command.internal.CommandExecutor;
import com.tangosol.net.BackingMapManagerContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class CommandExecutorManager {
    private static ConcurrentHashMap<Identifier, CommandExecutor> commandExecutors = new ConcurrentHashMap();
    private static ScheduledExecutorService executorService;
    private static ThreadGroup executorServiceThreadGroup;

    public static CommandExecutor ensureCommandExecutor(Identifier contextIdentifier, BackingMapManagerContext backingMapManagerContext) {
        CommandExecutor commandExecutor = commandExecutors.get(contextIdentifier);
        if (commandExecutor == null) {
            CommandExecutor previouslyRegisteredCommandExecutor;
            if (Logger.isEnabled((int)5)) {
                Logger.log((int)5, (String)"Creating CommandExecutor for %s", (Object[])new Object[]{contextIdentifier});
            }
            if ((previouslyRegisteredCommandExecutor = commandExecutors.putIfAbsent(contextIdentifier, commandExecutor = new CommandExecutor(contextIdentifier, backingMapManagerContext))) == null) {
                if (Logger.isEnabled((int)5)) {
                    Logger.log((int)5, (String)"Created CommandExecutor for %s", (Object[])new Object[]{contextIdentifier});
                }
            } else {
                commandExecutor = previouslyRegisteredCommandExecutor;
                if (Logger.isEnabled((int)5)) {
                    Logger.log((int)5, (String)"Using previously created CommandExecutor for %s", (Object[])new Object[]{contextIdentifier});
                }
            }
        }
        return commandExecutor;
    }

    public static CommandExecutor getCommandExecutor(Identifier contextIdentifier) {
        CommandExecutor commandExecutor = commandExecutors.get(contextIdentifier);
        return commandExecutor;
    }

    public static CommandExecutor removeCommandExecutor(Identifier contextIdentifier) {
        if (Logger.isEnabled((int)5)) {
            Logger.log((int)5, (String)"Removing CommandExecutor for %s", (Object[])new Object[]{contextIdentifier});
        }
        return commandExecutors.remove(contextIdentifier);
    }

    public static void schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        if (delay == 0L) {
            executorService.execute(runnable);
        } else {
            executorService.schedule(runnable, delay, timeUnit);
        }
    }

    static {
        executorServiceThreadGroup = new ThreadGroup("CommandExecutorManager");
        executorService = ExecutorServiceFactory.newScheduledThreadPool((int)5, (ThreadFactory)ThreadFactories.newThreadFactory((boolean)true, (String)"CommandExecutor", (ThreadGroup)executorServiceThreadGroup));
    }
}

