/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.common.sequencegenerators.ClusteredSequenceGenerator;
import com.oracle.coherence.common.sequencegenerators.SequenceGenerator;
import com.oracle.coherence.common.ticketing.Ticket;
import com.oracle.coherence.common.ticketing.TicketAggregator;
import com.oracle.coherence.common.ticketing.TicketBook;
import com.oracle.coherence.patterns.command.Context;
import com.oracle.coherence.patterns.command.ContextConfiguration;
import com.oracle.coherence.patterns.command.ExecutionEnvironment;
import com.oracle.coherence.patterns.command.PriorityCommand;
import com.oracle.coherence.patterns.command.internal.ClaimContextProcessor;
import com.oracle.coherence.patterns.command.internal.CommandExecutionRequest;
import com.oracle.coherence.patterns.command.internal.CommandExecutorMBean;
import com.oracle.coherence.patterns.command.internal.CommandExecutorManager;
import com.oracle.coherence.patterns.command.internal.ContextWrapper;
import com.oracle.coherence.patterns.command.internal.StartCommandProcessor;
import com.oracle.coherence.patterns.command.internal.SubmissionOutcome;
import com.oracle.coherence.patterns.command.internal.UpdateContextProcessor;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.management.Registry;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.processor.UpdaterProcessor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class CommandExecutor
implements CommandExecutorMBean {
    private static long OWNERSHIP_DOUBT_DELAY_SECONDS = 2L;
    private Identifier contextIdentifier;
    private ContextConfiguration contextConfiguration;
    private BackingMapManagerContext backingMapManagerContext;
    private volatile State state;
    private SequenceGenerator sequenceGenerator;
    private long ticketIssuerId;
    private LinkedList<TicketBook> recoveredTicketBooks;
    private TicketBook ticketBook;
    private TicketBook priorityTicketBook;
    private long contextVersion;
    private String mBeanName;
    private long localCommandsSubmitted;
    private long localCommandsExecuted;
    private long localLastCommandExecutionDuration;
    private long localCommandExecutionDuration;
    private long localMinimumCommandExecutionDuration;
    private long localMaximumCommandExecutionDuration;
    private long localCommandExecutionServiceDuration;
    private long totalCommandsExecuted;
    private long totalCommandExecutionDuration;
    private long totalCommandExecutionWaitingDuration;
    private int maximumBatchSize;

    public CommandExecutor(Identifier contextIdentifier, BackingMapManagerContext backingMapManagerContext) {
        this.contextIdentifier = contextIdentifier;
        this.contextConfiguration = null;
        this.backingMapManagerContext = backingMapManagerContext;
        this.state = State.New;
        this.sequenceGenerator = new ClusteredSequenceGenerator("ticketIssuerIds", 0L);
        this.ticketIssuerId = this.sequenceGenerator.next(2L).getFrom();
        this.ticketBook = new TicketBook(this.ticketIssuerId);
        this.priorityTicketBook = new TicketBook(Long.MIN_VALUE + this.ticketIssuerId);
        this.recoveredTicketBooks = new LinkedList();
        this.contextVersion = -1L;
        this.mBeanName = null;
        this.localCommandsSubmitted = 0L;
        this.localCommandsExecuted = 0L;
        this.localLastCommandExecutionDuration = 0L;
        this.localCommandExecutionDuration = 0L;
        this.localCommandExecutionServiceDuration = 0L;
        this.localMaximumCommandExecutionDuration = Long.MIN_VALUE;
        this.localMinimumCommandExecutionDuration = Long.MAX_VALUE;
        this.totalCommandsExecuted = 0L;
        this.totalCommandExecutionDuration = 0L;
        this.totalCommandExecutionWaitingDuration = 0L;
        this.maximumBatchSize = 50;
    }

    public Identifier getContextIdentifier() {
        return this.contextIdentifier;
    }

    public void setState(State state) {
        if (this.state == State.Stopped && state != State.Stopped) {
            Logger.log((int)1, (String)"Attempting to set the CommandExecutor %s state to %s when it's already Stopped", (Object[])new Object[]{this.contextIdentifier, this.state});
        } else {
            this.state = state;
        }
    }

    public State getState() {
        return this.state;
    }

    public String getMBeanName() {
        return this.mBeanName;
    }

    void setMBeanName(String mBeanName) {
        this.mBeanName = mBeanName;
    }

    @Override
    public String getContextIdentity() {
        return this.contextIdentifier.toString();
    }

    @Override
    public long getContextVersion() {
        return this.contextVersion;
    }

    @Override
    public String getStatus() {
        return this.state.name();
    }

    @Override
    public long getTicketIssuerId() {
        return this.ticketIssuerId;
    }

    @Override
    public long getTotalCommandsPendingExecution() {
        long totalPendingCommands = this.ticketBook.size();
        if (this.recoveredTicketBooks != null && !this.recoveredTicketBooks.isEmpty()) {
            for (TicketBook ticketBook : this.recoveredTicketBooks) {
                totalPendingCommands += ticketBook.size();
            }
        }
        return totalPendingCommands;
    }

    @Override
    public long getLocalCommandsSubmitted() {
        return this.localCommandsSubmitted;
    }

    @Override
    public long getLocalCommandsExecuted() {
        return this.localCommandsExecuted;
    }

    @Override
    public double getLocalAverageCommandExecutionDuration() {
        if (this.getLocalCommandsExecuted() == 0L) {
            return 0.0;
        }
        return (double)this.localCommandExecutionDuration / (double)this.getLocalCommandsExecuted();
    }

    @Override
    public double getLocalLastCommandExecutionDuration() {
        return this.localLastCommandExecutionDuration;
    }

    @Override
    public double getLocalCommandExecutionServiceDuration() {
        return this.localCommandExecutionServiceDuration;
    }

    @Override
    public double getLocalMinimumCommandExecutionDuration() {
        if (this.localMinimumCommandExecutionDuration == Long.MAX_VALUE) {
            return 0.0;
        }
        return this.localMinimumCommandExecutionDuration;
    }

    @Override
    public double getLocalMaximumCommandExecutionDuration() {
        if (this.localMaximumCommandExecutionDuration == Long.MIN_VALUE) {
            return 0.0;
        }
        return this.localMaximumCommandExecutionDuration;
    }

    @Override
    public long getTotalCommandsExecuted() {
        return this.totalCommandsExecuted;
    }

    @Override
    public long getTotalCommandExecutionDuration() {
        return this.totalCommandExecutionDuration;
    }

    @Override
    public long getTotalCommandExecutionWaitingDuration() {
        return this.totalCommandExecutionWaitingDuration;
    }

    private boolean isContextOwned() {
        PartitionedService partitionedService = (PartitionedService)this.backingMapManagerContext.getCacheService();
        Member keyOwner = partitionedService.getKeyOwner((Object)this.contextIdentifier);
        return CacheFactory.getCluster().getLocalMember().equals(keyOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.getState() == State.New) {
            NamedCache contextsCache;
            ContextWrapper contextWrapper;
            if (Logger.isEnabled((int)5)) {
                Logger.log((int)5, (String)"Starting CommandExecutor for %s", (Object[])new Object[]{this.contextIdentifier});
            }
            if ((contextWrapper = (ContextWrapper)(contextsCache = CacheFactory.getCache((String)"coherence.commandpattern.contexts")).invoke((Object)this.contextIdentifier, (InvocableMap.EntryProcessor)new ClaimContextProcessor(CacheFactory.getCluster().getLocalMember().getUid()))) == null) {
                if (Logger.isEnabled((int)5)) {
                    Logger.log((int)5, (String)"CommandExecutor for %s can not be started.  The Context has been moved (or deleted) since the CommandExecutor was established and scheduled to start.  Now stopped.", (Object[])new Object[]{this.contextIdentifier});
                }
                this.stop();
            } else {
                Registry registry;
                CommandExecutor commandExecutor = this;
                synchronized (commandExecutor) {
                    ++this.ticketIssuerId;
                    this.ticketBook = new TicketBook(this.ticketIssuerId);
                    this.priorityTicketBook = new TicketBook(Long.MIN_VALUE + this.ticketIssuerId);
                    this.contextConfiguration = contextWrapper.getContextConfiguration();
                    this.contextVersion = contextWrapper.getContextVersion();
                    this.totalCommandsExecuted = contextWrapper.getTotalCommandsExecuted();
                    this.totalCommandExecutionDuration = contextWrapper.getTotalCommandExecutionDuration();
                    this.totalCommandExecutionWaitingDuration = contextWrapper.getTotalCommandExecutionWaitingDuration();
                }
                if (Logger.isEnabled((int)5)) {
                    Logger.log((int)5, (String)"CommandExecutor for %s has been configured as %s", (Object[])new Object[]{this.contextIdentifier, this.contextConfiguration});
                }
                if (Logger.isEnabled((int)5)) {
                    Logger.log((int)5, (String)"Recovering unexecuted commands for CommandExecutor %s ", (Object[])new Object[]{this.contextIdentifier});
                }
                EqualsFilter filter = new EqualsFilter("getContextIdentifier", (Object)this.getContextIdentifier());
                TreeSet recoveredTicketBookSet = new TreeSet();
                recoveredTicketBookSet.addAll((LinkedList)CacheFactory.getCache((String)CommandExecutionRequest.getCacheName(ContextConfiguration.ManagementStrategy.DISTRIBUTED)).aggregate((Filter)filter, (InvocableMap.EntryAggregator)new TicketAggregator("getTicket")));
                recoveredTicketBookSet.addAll((LinkedList)CacheFactory.getCache((String)CommandExecutionRequest.getCacheName(ContextConfiguration.ManagementStrategy.COLOCATED)).aggregate((Filter)new KeyAssociatedFilter((Filter)filter, (Object)this.getContextIdentifier()), (InvocableMap.EntryAggregator)new TicketAggregator("getTicket")));
                CommandExecutor commandExecutor2 = this;
                synchronized (commandExecutor2) {
                    this.recoveredTicketBooks.addAll(recoveredTicketBookSet);
                    if (this.recoveredTicketBooks.size() > 0) {
                        if (Logger.isEnabled((int)5)) {
                            Logger.log((int)5, (String)"Recovered %d Tickets for CommandExecutor %s. Books are %s", (Object[])new Object[]{this.getTotalCommandsPendingExecution() - this.ticketBook.size(), this.contextIdentifier, this.recoveredTicketBooks});
                        }
                    } else if (Logger.isEnabled((int)5)) {
                        Logger.log((int)5, (String)"No commands to recover for CommandExecutor %s", (Object[])new Object[]{this.contextIdentifier});
                    }
                }
                Registry registry2 = registry = CacheFactory.getCluster() == null ? null : CacheFactory.getCluster().getManagement();
                if (registry != null) {
                    if (Logger.isEnabled((int)5)) {
                        Logger.log((int)5, (String)"Registering JMX management extensions for CommandExecutor %s", (Object[])new Object[]{this.contextIdentifier});
                    }
                    this.setMBeanName(registry.ensureGlobalName(String.format("type=CommandExecutor,id=%s", this.contextIdentifier)));
                    registry.register(this.getMBeanName(), (Object)this);
                }
                if (this.recoveredTicketBooks.isEmpty() && this.ticketBook.isEmpty()) {
                    if (Logger.isEnabled((int)5)) {
                        Logger.log((int)5, (String)"No commands to execute for CommandExecutor %s.  (waiting for commands to be submitted)", (Object[])new Object[]{this.contextIdentifier});
                    }
                    this.setState(State.Waiting);
                } else {
                    if (Logger.isEnabled((int)5)) {
                        Logger.log((int)5, (String)"Scheduling CommandExecutor %s to execute commands", (Object[])new Object[]{this.contextIdentifier});
                    }
                    this.setState(State.Scheduled);
                    CommandExecutorManager.schedule(new Runnable(){

                        @Override
                        public void run() {
                            CommandExecutor.this.execute();
                        }
                    }, 0L, TimeUnit.SECONDS);
                }
                if (Logger.isEnabled((int)5)) {
                    Logger.log((int)5, (String)"Started CommandExecutor for %s", (Object[])new Object[]{this.contextIdentifier});
                }
            }
        } else if (Logger.isEnabled((int)5)) {
            Logger.log((int)5, (String)"Attempted to start CommandExecutor for %s, but it's already Started (current state %s)", (Object[])new Object[]{this.contextIdentifier, this.getState()});
        }
    }

    public void stop() {
        Registry registry;
        if (Logger.isEnabled((int)5)) {
            Logger.log((int)5, (String)"Stopping CommandExecutor for %s", (Object[])new Object[]{this.contextIdentifier});
        }
        this.setState(State.Stopped);
        CommandExecutorManager.removeCommandExecutor(this.getContextIdentifier());
        Registry registry2 = registry = CacheFactory.getCluster() == null ? null : CacheFactory.getCluster().getManagement();
        if (registry != null) {
            if (Logger.isEnabled((int)5)) {
                Logger.log((int)5, (String)"Unregistering JMX management extensions for CommandExecutor %s", (Object[])new Object[]{this.contextIdentifier});
            }
            registry.unregister(this.getMBeanName());
        }
        if (Logger.isEnabled((int)5)) {
            Logger.log((int)5, (String)"Stopped CommandExecutor for %s", (Object[])new Object[]{this.contextIdentifier});
        }
    }

    public synchronized SubmissionOutcome acceptCommandExecutionRequest(CommandExecutionRequest commandExecutionRequest) {
        if (this.getState() == State.Stopped) {
            if (Logger.isEnabled((int)5)) {
                Logger.log((int)5, (String)"CommandExecutor for %s can't accept %s as it has been Stopped", (Object[])new Object[]{this.contextIdentifier, commandExecutionRequest});
            }
            return new SubmissionOutcome.UnknownContext();
        }
        if (this.isContextOwned()) {
            Ticket ticket = (commandExecutionRequest.getCommand() instanceof PriorityCommand ? this.priorityTicketBook : this.ticketBook).extend();
            commandExecutionRequest.setTicket(ticket);
            commandExecutionRequest.setInstantQueued(CacheFactory.getSafeTimeMillis());
            ContextConfiguration.ManagementStrategy managementStrategy = ticket.getIssuerId() % 2L == 0L || ticket.getIssuerId() < 0L ? ContextConfiguration.ManagementStrategy.COLOCATED : this.contextConfiguration.getManagementStrategy();
            CommandExecutionRequest.Key key = new CommandExecutionRequest.Key(this.contextIdentifier, ticket, managementStrategy);
            String cacheName = CommandExecutionRequest.getCacheName(managementStrategy);
            if (managementStrategy == ContextConfiguration.ManagementStrategy.COLOCATED) {
                DistributedCacheService distributedCacheService = (DistributedCacheService)CacheFactory.getService((String)"DistributedCacheForCommandPattern");
                DefaultConfigurableCacheFactory.Manager backingMapManager = (DefaultConfigurableCacheFactory.Manager)distributedCacheService.getBackingMapManager();
                backingMapManager.getBackingMap(cacheName).put(backingMapManager.getContext().getKeyToInternalConverter().convert((Object)key), backingMapManager.getContext().getValueToInternalConverter().convert((Object)commandExecutionRequest));
            } else {
                NamedCache commandsCache = CacheFactory.getCache((String)cacheName);
                commandsCache.put((Object)key, (Object)commandExecutionRequest);
            }
            ++this.localCommandsSubmitted;
            if (this.getState() == State.Waiting) {
                this.setState(State.Scheduled);
                CommandExecutorManager.schedule(new Runnable(){

                    @Override
                    public void run() {
                        CommandExecutor.this.execute();
                    }
                }, 0L, TimeUnit.SECONDS);
            }
            return new SubmissionOutcome.Accepted(key, managementStrategy);
        }
        if (Logger.isEnabled((int)5)) {
            Logger.log((int)5, (String)"CommandExecutor for %s can't accept %s as Context ownership is currently in doubt", (Object[])new Object[]{this.contextIdentifier, commandExecutionRequest});
        }
        return new SubmissionOutcome.UnknownContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() {
        block67: {
            try {
                if (this.getState() == State.Scheduled) {
                    if (this.isContextOwned()) {
                        TicketBook executionTicketBook22 = null;
                        Iterator ticketsToExecute = null;
                        CommandExecutor commandExecutor = this;
                        synchronized (commandExecutor) {
                            while (!this.recoveredTicketBooks.isEmpty() && executionTicketBook22 == null) {
                                executionTicketBook22 = this.recoveredTicketBooks.getFirst();
                                if (!executionTicketBook22.isEmpty()) continue;
                                this.recoveredTicketBooks.removeFirst();
                                executionTicketBook22 = null;
                            }
                            if (!this.priorityTicketBook.isEmpty()) {
                                if (executionTicketBook22 == null) {
                                    executionTicketBook22 = this.priorityTicketBook;
                                } else if (executionTicketBook22.getIssuerId() >= 0L) {
                                    executionTicketBook22 = this.priorityTicketBook;
                                }
                            }
                            if (executionTicketBook22 == null) {
                                executionTicketBook22 = this.ticketBook;
                            }
                            if (executionTicketBook22.isEmpty()) {
                                this.setState(State.Waiting);
                            } else {
                                this.setState(State.Executing);
                                ticketsToExecute = executionTicketBook22.first((long)this.maximumBatchSize);
                            }
                        }
                        if (this.getState() == State.Executing) {
                            NamedCache contextWrapperCache = CacheFactory.getCache((String)"coherence.commandpattern.contexts");
                            ContextWrapper contextWrapper = (ContextWrapper)contextWrapperCache.get((Object)this.contextIdentifier);
                            this.totalCommandsExecuted = contextWrapper.getTotalCommandsExecuted();
                            if (contextWrapper.getContextVersion() == this.contextVersion) {
                                Environment environment = new Environment(contextWrapper);
                                while (this.isContextOwned() && this.getState() == State.Executing && ticketsToExecute.hasNext()) {
                                    block66: {
                                        Ticket ticket = (Ticket)ticketsToExecute.next();
                                        ContextConfiguration.ManagementStrategy managementStrategy = ticket.getIssuerId() % 2L == 0L || ticket.getIssuerId() < 0L ? ContextConfiguration.ManagementStrategy.COLOCATED : this.contextConfiguration.getManagementStrategy();
                                        CommandExecutionRequest.Key commandExecutionRequestKey = new CommandExecutionRequest.Key(this.contextIdentifier, ticket, managementStrategy);
                                        long startLocalServiceExecuteTime = CacheFactory.getSafeTimeMillis();
                                        NamedCache commandExecutionRequestsCache = CacheFactory.getCache((String)CommandExecutionRequest.getCacheName(managementStrategy));
                                        CommandExecutionRequest commandExecutionRequest = (CommandExecutionRequest)commandExecutionRequestsCache.invoke((Object)commandExecutionRequestKey, (InvocableMap.EntryProcessor)new StartCommandProcessor());
                                        if (commandExecutionRequest != null) {
                                            long localLastCommandExecutionWaitingDuration;
                                            long endCommandExecutionTime;
                                            long startCommandExecutionTime;
                                            if (commandExecutionRequest.isCanceled()) {
                                                if (Logger.isEnabled((int)6)) {
                                                    Logger.log((int)6, (String)"Skipping %s for CommandExecutor %s as it was canceled", (Object[])new Object[]{commandExecutionRequest, this.contextIdentifier});
                                                }
                                            } else {
                                                environment.configure(ticket, managementStrategy, ticket.getIssuerId() < this.getTicketIssuerId() - 1L && ticket.getIssuerId() + Long.MIN_VALUE != this.getTicketIssuerId() - 1L, commandExecutionRequest.getCheckpoint());
                                                startCommandExecutionTime = CacheFactory.getSafeTimeMillis();
                                                if (Logger.isEnabled((int)6)) {
                                                    Logger.log((int)6, (String)"Executing %s for CommandExecutor %s", (Object[])new Object[]{commandExecutionRequest, this.contextIdentifier});
                                                }
                                                commandExecutionRequest.getCommand().execute(environment);
                                                endCommandExecutionTime = CacheFactory.getSafeTimeMillis();
                                                ++this.localCommandsExecuted;
                                                this.localLastCommandExecutionDuration = Math.max(0L, endCommandExecutionTime - startCommandExecutionTime);
                                                this.localCommandExecutionServiceDuration += endCommandExecutionTime - startLocalServiceExecuteTime;
                                                localLastCommandExecutionWaitingDuration = Math.max(0L, startCommandExecutionTime - commandExecutionRequest.getInstantQueued());
                                                this.localCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                this.localMaximumCommandExecutionDuration = Math.max(this.localMaximumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                this.localMinimumCommandExecutionDuration = Math.min(this.localMinimumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                ++this.totalCommandsExecuted;
                                                this.totalCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                this.totalCommandExecutionWaitingDuration += localLastCommandExecutionWaitingDuration;
                                                if (((Boolean)contextWrapperCache.invoke((Object)this.contextIdentifier, (InvocableMap.EntryProcessor)new UpdateContextProcessor(this.contextVersion, environment.isContextUpdated() ? environment.getContext() : null, ticket, this.localCommandExecutionDuration, localLastCommandExecutionWaitingDuration))).booleanValue()) {
                                                    commandExecutionRequestsCache.remove((Object)commandExecutionRequestKey);
                                                } else {
                                                    if (Logger.isEnabled((int)5)) {
                                                        Logger.log((int)5, (String)"Failed to update ContextWrapper for %s as the CommandExecutor no longer owns the Context.  Detected that the context version number has changed during UpdateContextProcessor.", (Object[])new Object[]{this.contextIdentifier});
                                                    }
                                                    this.stop();
                                                }
                                            }
                                            break block66;
                                            catch (RuntimeException runtimeException) {
                                                Logger.log((int)1, (String)"Failed to execute %s with CommandExecutor %s", (Object[])new Object[]{commandExecutionRequestKey, this.contextIdentifier});
                                                CacheFactory.log((Throwable)runtimeException);
                                                endCommandExecutionTime = CacheFactory.getSafeTimeMillis();
                                                ++this.localCommandsExecuted;
                                                this.localLastCommandExecutionDuration = Math.max(0L, endCommandExecutionTime - startCommandExecutionTime);
                                                this.localCommandExecutionServiceDuration += endCommandExecutionTime - startLocalServiceExecuteTime;
                                                localLastCommandExecutionWaitingDuration = Math.max(0L, startCommandExecutionTime - commandExecutionRequest.getInstantQueued());
                                                this.localCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                this.localMaximumCommandExecutionDuration = Math.max(this.localMaximumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                this.localMinimumCommandExecutionDuration = Math.min(this.localMinimumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                ++this.totalCommandsExecuted;
                                                this.totalCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                this.totalCommandExecutionWaitingDuration += localLastCommandExecutionWaitingDuration;
                                                if (((Boolean)contextWrapperCache.invoke((Object)this.contextIdentifier, (InvocableMap.EntryProcessor)new UpdateContextProcessor(this.contextVersion, environment.isContextUpdated() ? environment.getContext() : null, ticket, this.localCommandExecutionDuration, localLastCommandExecutionWaitingDuration))).booleanValue()) {
                                                    commandExecutionRequestsCache.remove((Object)commandExecutionRequestKey);
                                                } else {
                                                    if (Logger.isEnabled((int)5)) {
                                                        Logger.log((int)5, (String)"Failed to update ContextWrapper for %s as the CommandExecutor no longer owns the Context.  Detected that the context version number has changed during UpdateContextProcessor.", (Object[])new Object[]{this.contextIdentifier});
                                                    }
                                                    this.stop();
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Logger.log((int)1, (String)"Failed to execute %s with CommandExecutor %s", (Object[])new Object[]{commandExecutionRequestKey, this.contextIdentifier});
                                                CacheFactory.log((Throwable)throwable);
                                                {
                                                    catch (Throwable throwable2) {
                                                        long endCommandExecutionTime2 = CacheFactory.getSafeTimeMillis();
                                                        ++this.localCommandsExecuted;
                                                        this.localLastCommandExecutionDuration = Math.max(0L, endCommandExecutionTime2 - startCommandExecutionTime);
                                                        this.localCommandExecutionServiceDuration += endCommandExecutionTime2 - startLocalServiceExecuteTime;
                                                        long localLastCommandExecutionWaitingDuration2 = Math.max(0L, startCommandExecutionTime - commandExecutionRequest.getInstantQueued());
                                                        this.localCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                        this.localMaximumCommandExecutionDuration = Math.max(this.localMaximumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                        this.localMinimumCommandExecutionDuration = Math.min(this.localMinimumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                        ++this.totalCommandsExecuted;
                                                        this.totalCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                        this.totalCommandExecutionWaitingDuration += localLastCommandExecutionWaitingDuration2;
                                                        if (((Boolean)contextWrapperCache.invoke((Object)this.contextIdentifier, (InvocableMap.EntryProcessor)new UpdateContextProcessor(this.contextVersion, environment.isContextUpdated() ? environment.getContext() : null, ticket, this.localCommandExecutionDuration, localLastCommandExecutionWaitingDuration2))).booleanValue()) {
                                                            commandExecutionRequestsCache.remove((Object)commandExecutionRequestKey);
                                                        } else {
                                                            if (Logger.isEnabled((int)5)) {
                                                                Logger.log((int)5, (String)"Failed to update ContextWrapper for %s as the CommandExecutor no longer owns the Context.  Detected that the context version number has changed during UpdateContextProcessor.", (Object[])new Object[]{this.contextIdentifier});
                                                            }
                                                            this.stop();
                                                        }
                                                        throw throwable2;
                                                    }
                                                }
                                                endCommandExecutionTime = CacheFactory.getSafeTimeMillis();
                                                ++this.localCommandsExecuted;
                                                this.localLastCommandExecutionDuration = Math.max(0L, endCommandExecutionTime - startCommandExecutionTime);
                                                this.localCommandExecutionServiceDuration += endCommandExecutionTime - startLocalServiceExecuteTime;
                                                localLastCommandExecutionWaitingDuration = Math.max(0L, startCommandExecutionTime - commandExecutionRequest.getInstantQueued());
                                                this.localCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                this.localMaximumCommandExecutionDuration = Math.max(this.localMaximumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                this.localMinimumCommandExecutionDuration = Math.min(this.localMinimumCommandExecutionDuration, this.localLastCommandExecutionDuration);
                                                ++this.totalCommandsExecuted;
                                                this.totalCommandExecutionDuration += this.localLastCommandExecutionDuration;
                                                this.totalCommandExecutionWaitingDuration += localLastCommandExecutionWaitingDuration;
                                                if (((Boolean)contextWrapperCache.invoke((Object)this.contextIdentifier, (InvocableMap.EntryProcessor)new UpdateContextProcessor(this.contextVersion, environment.isContextUpdated() ? environment.getContext() : null, ticket, this.localCommandExecutionDuration, localLastCommandExecutionWaitingDuration))).booleanValue()) {
                                                    commandExecutionRequestsCache.remove((Object)commandExecutionRequestKey);
                                                } else {
                                                    if (Logger.isEnabled((int)5)) {
                                                        Logger.log((int)5, (String)"Failed to update ContextWrapper for %s as the CommandExecutor no longer owns the Context.  Detected that the context version number has changed during UpdateContextProcessor.", (Object[])new Object[]{this.contextIdentifier});
                                                    }
                                                    this.stop();
                                                }
                                            }
                                        }
                                    }
                                    CommandExecutor commandExecutor2 = this;
                                    synchronized (commandExecutor2) {
                                        executionTicketBook22.consume(1L);
                                        if (executionTicketBook22.isEmpty() && Logger.isEnabled((int)6)) {
                                            Logger.log((int)6, (String)"Completed %s for ContextWrapper for %s", (Object[])new Object[]{executionTicketBook22, this.contextIdentifier});
                                        }
                                    }
                                }
                                CommandExecutor commandExecutor3 = this;
                                synchronized (commandExecutor3) {
                                    if (this.isContextOwned()) {
                                        if (this.getState() == State.Executing) {
                                            if (this.ticketBook.isEmpty() && this.recoveredTicketBooks.isEmpty() && this.priorityTicketBook.isEmpty()) {
                                                this.setState(State.Waiting);
                                            } else {
                                                this.setState(State.Scheduled);
                                                CommandExecutorManager.schedule(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        CommandExecutor.this.execute();
                                                    }
                                                }, 0L, TimeUnit.SECONDS);
                                            }
                                        } else if (Logger.isEnabled((int)5)) {
                                            Logger.log((int)5, (String)"CommandExecutor for %s has been Stopped during execution.", (Object[])new Object[]{this.contextIdentifier, this.getState()});
                                        }
                                    } else {
                                        if (Logger.isEnabled((int)5)) {
                                            Logger.log((int)5, (String)"Ownership for CommandExecutor %s is currently in doubt (after execution).  Delaying execution for %d seconds", (Object[])new Object[]{this.contextIdentifier, OWNERSHIP_DOUBT_DELAY_SECONDS});
                                        }
                                        this.setState(State.Scheduled);
                                        CommandExecutorManager.schedule(new Runnable(){

                                            @Override
                                            public void run() {
                                                CommandExecutor.this.execute();
                                            }
                                        }, OWNERSHIP_DOUBT_DELAY_SECONDS, TimeUnit.SECONDS);
                                    }
                                    break block67;
                                }
                            }
                            if (Logger.isEnabled((int)5)) {
                                Logger.log((int)5, (String)"CommandExecutor for %s no longer owns the Context.  Detected that the context version number has changed.", (Object[])new Object[]{this.contextIdentifier});
                            }
                            this.stop();
                            break block67;
                        }
                        if (Logger.isEnabled((int)5)) {
                            Logger.log((int)5, (String)"CommandExecutor for %s was scheduled to execute, but no longer needs to do so.  (current state is %s, %d pending commands)", (Object[])new Object[]{this.contextIdentifier, this.getState(), this.getTotalCommandsPendingExecution()});
                        }
                        break block67;
                    }
                    if (Logger.isEnabled((int)5)) {
                        Logger.log((int)5, (String)"Ownership for CommandExecutor %s is currently in doubt.  Delaying execution for %d seconds", (Object[])new Object[]{this.contextIdentifier, OWNERSHIP_DOUBT_DELAY_SECONDS});
                    }
                    CommandExecutor executionTicketBook22 = this;
                    synchronized (executionTicketBook22) {
                        this.setState(State.Scheduled);
                        CommandExecutorManager.schedule(new Runnable(){

                            @Override
                            public void run() {
                                CommandExecutor.this.execute();
                            }
                        }, OWNERSHIP_DOUBT_DELAY_SECONDS, TimeUnit.SECONDS);
                        break block67;
                    }
                }
                if (Logger.isEnabled((int)5)) {
                    Logger.log((int)5, (String)"CommandExecutor for %s was scheduled to execute, but it is no longer executable (current state is %s)", (Object[])new Object[]{this.contextIdentifier, this.getState()});
                }
            }
            catch (RuntimeException runtimeException) {
                if (Logger.isEnabled((int)1)) {
                    Logger.log((int)1, (String)"CommandExecutor for %s failed horribly...", (Object[])new Object[]{this.contextIdentifier});
                }
                runtimeException.printStackTrace();
                this.setState(State.Waiting);
            }
            catch (Throwable throwable) {
                if (Logger.isEnabled((int)1)) {
                    Logger.log((int)1, (String)"CommandExecutor for %s failed horribly...", (Object[])new Object[]{this.contextIdentifier});
                }
                throwable.printStackTrace();
                this.setState(State.Waiting);
            }
        }
    }

    static class Environment
    implements ExecutionEnvironment {
        private Identifier contextIdentifier;
        private Context context;
        private ContextConfiguration contextConfiguration;
        private ContextConfiguration.ManagementStrategy managementStrategy;
        private boolean isContextUpdated;
        private boolean isRecovering;
        private Ticket ticket;
        private Object checkpoint;

        public Environment(ContextWrapper contextWrapper) {
            this.contextIdentifier = contextWrapper.getContentIdentifier();
            this.context = contextWrapper.getContext();
            this.contextConfiguration = contextWrapper.getContextConfiguration();
            this.managementStrategy = ContextConfiguration.ManagementStrategy.COLOCATED;
            this.isContextUpdated = false;
            this.isRecovering = false;
            this.ticket = null;
        }

        @Override
        public Identifier getContextIdentifier() {
            return this.contextIdentifier;
        }

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            if (context == null) {
                throw new IllegalStateException(String.format("Attempted to set the Context known as %s to null for Command with %s", this.contextIdentifier, this.ticket));
            }
            this.context = context;
            this.isContextUpdated = true;
        }

        @Override
        public ContextConfiguration getContextConfiguration() {
            return this.contextConfiguration;
        }

        public ContextConfiguration.ManagementStrategy getManagementStrategy() {
            return this.managementStrategy;
        }

        @Override
        public boolean isRecovering() {
            return this.isRecovering;
        }

        public void configure(Ticket ticket, ContextConfiguration.ManagementStrategy managementStrategy, boolean isRecovering, Object checkpoint) {
            this.isContextUpdated = false;
            this.ticket = ticket;
            this.managementStrategy = managementStrategy;
            this.isRecovering = isRecovering;
            this.checkpoint = checkpoint;
        }

        public boolean isContextUpdated() {
            return this.isContextUpdated;
        }

        @Override
        public Ticket getTicket() {
            return this.ticket;
        }

        @Override
        public boolean hasCheckpoint() {
            return this.checkpoint != null;
        }

        @Override
        public Object loadCheckpoint() {
            return this.checkpoint;
        }

        @Override
        public void saveCheckpoint(Object checkpoint) {
            this.checkpoint = checkpoint;
            CommandExecutionRequest.Key commandExecutionRequestKey = new CommandExecutionRequest.Key(this.contextIdentifier, this.ticket, this.managementStrategy);
            CacheFactory.getCache((String)CommandExecutionRequest.getCacheName(this.managementStrategy)).invoke((Object)commandExecutionRequestKey, (InvocableMap.EntryProcessor)new UpdaterProcessor("setCheckpoint", checkpoint));
        }

        @Override
        public void removeCheckpoint() {
            this.saveCheckpoint(null);
        }
    }

    public static enum State {
        New,
        Starting,
        Waiting,
        Scheduled,
        Executing,
        Stopped;

    }
}

