/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.ticketing.Ticket;
import com.oracle.coherence.patterns.command.Command;
import com.oracle.coherence.patterns.command.ContextConfiguration;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

public class CommandExecutionRequest
implements ExternalizableLite,
PortableObject,
Comparable<CommandExecutionRequest> {
    private static final String COLOCATED_COMMANDS_CACHENAME = "coherence.commandpattern.commands.colocated";
    private static final String DISTRIBUTED_COMMANDS_CACHENAME = "coherence.commandpattern.commands.distributed";
    private Identifier contextIdentifier;
    private Ticket ticket;
    private Command<?> command;
    private long instantQueued;
    private Status status;
    private Object checkpoint;

    public CommandExecutionRequest() {
    }

    public CommandExecutionRequest(Identifier contextIdentifier, Command<?> command) {
        this.contextIdentifier = contextIdentifier;
        this.ticket = null;
        this.command = command;
        this.instantQueued = 0L;
        this.status = Status.Pending;
        this.checkpoint = null;
    }

    public Identifier getContextIdentifier() {
        return this.contextIdentifier;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public long getInstantQueued() {
        return this.instantQueued;
    }

    public void setInstantQueued(long instantQueued) {
        this.instantQueued = instantQueued;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isCanceled() {
        return this.getStatus() == Status.Canceled;
    }

    public Object getCheckpoint() {
        return this.checkpoint;
    }

    public void setCheckpoint(Object checkpoint) {
        this.checkpoint = checkpoint;
    }

    public void readExternal(DataInput in) throws IOException {
        this.contextIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
        this.ticket = (Ticket)ExternalizableHelper.readObject((DataInput)in);
        this.command = (Command)ExternalizableHelper.readObject((DataInput)in);
        this.instantQueued = ExternalizableHelper.readLong((DataInput)in);
        this.status = Status.values()[ExternalizableHelper.readInt((DataInput)in)];
        this.checkpoint = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.contextIdentifier);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.ticket);
        ExternalizableHelper.writeObject((DataOutput)out, this.command);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.instantQueued);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.status.ordinal());
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.checkpoint);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.contextIdentifier = (Identifier)reader.readObject(0);
        this.ticket = (Ticket)reader.readObject(1);
        this.command = (Command)reader.readObject(2);
        this.instantQueued = reader.readLong(3);
        this.status = Status.values()[reader.readInt(4)];
        this.checkpoint = reader.readObject(5);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.contextIdentifier);
        writer.writeObject(1, (Object)this.ticket);
        writer.writeObject(2, this.command);
        writer.writeLong(3, this.instantQueued);
        writer.writeInt(4, this.status.ordinal());
        writer.writeObject(5, this.checkpoint);
    }

    @Override
    public int compareTo(CommandExecutionRequest other) {
        return this.getTicket().compareTo(other.getTicket());
    }

    public String toString() {
        return String.format("CommandExecutionRequest{contextIdentifier=%s, ticket=%s, command=%s, instantQueued=%s, status=%s, checkpoint=%s}", new Object[]{this.contextIdentifier, this.ticket, this.command, new Date(this.instantQueued), this.status, this.checkpoint});
    }

    public static String getCacheName(ContextConfiguration.ManagementStrategy managementStrategy) {
        return managementStrategy == ContextConfiguration.ManagementStrategy.COLOCATED ? COLOCATED_COMMANDS_CACHENAME : DISTRIBUTED_COMMANDS_CACHENAME;
    }

    public static class Key
    implements ExternalizableLite,
    PortableObject,
    KeyAssociation,
    Identifier {
        private Identifier contextIdentifier;
        private Ticket ticket;
        private ContextConfiguration.ManagementStrategy managementStrategy;

        public Key() {
        }

        public Key(Identifier contextIdentifier, Ticket ticket, ContextConfiguration.ManagementStrategy managementStrategy) {
            this.contextIdentifier = contextIdentifier;
            this.ticket = ticket;
            this.managementStrategy = managementStrategy;
        }

        public Identifier getContextIdentifier() {
            return this.contextIdentifier;
        }

        public Object getAssociatedKey() {
            return this.managementStrategy == ContextConfiguration.ManagementStrategy.COLOCATED ? this.contextIdentifier : this.ticket;
        }

        public void readExternal(DataInput in) throws IOException {
            this.contextIdentifier = (Identifier)ExternalizableHelper.readObject((DataInput)in);
            this.ticket = (Ticket)ExternalizableHelper.readExternalizableLite((DataInput)in);
            this.managementStrategy = ContextConfiguration.ManagementStrategy.values()[ExternalizableHelper.readInt((DataInput)in)];
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.contextIdentifier);
            ExternalizableHelper.writeExternalizableLite((DataOutput)out, (ExternalizableLite)this.ticket);
            ExternalizableHelper.writeInt((DataOutput)out, (int)this.managementStrategy.ordinal());
        }

        public void readExternal(PofReader reader) throws IOException {
            this.contextIdentifier = (Identifier)reader.readObject(0);
            this.ticket = (Ticket)reader.readObject(1);
            this.managementStrategy = ContextConfiguration.ManagementStrategy.values()[reader.readInt(2)];
        }

        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, (Object)this.contextIdentifier);
            writer.writeObject(1, (Object)this.ticket);
            writer.writeInt(2, this.managementStrategy.ordinal());
        }

        public String toString() {
            return String.format("CommandExecutionRequest.Key{contextIdentifier=%s, ticket=%s, managementStrategy=%s}", new Object[]{this.contextIdentifier, this.ticket, this.managementStrategy});
        }
    }

    public static enum Status {
        Pending,
        Started,
        Canceled;

    }
}

