/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.internal;

import com.oracle.coherence.patterns.command.internal.ContextWrapper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UID;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClaimContextProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private UID memberUID;

    public ClaimContextProcessor() {
    }

    public ClaimContextProcessor(UID memberUID) {
        this.memberUID = memberUID;
    }

    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent() && CacheFactory.getCluster().getLocalMember().getUid().equals((Object)this.memberUID)) {
            ContextWrapper contextWrapper = (ContextWrapper)entry.getValue();
            contextWrapper.nextVersion();
            entry.setValue((Object)contextWrapper);
            return contextWrapper;
        }
        return null;
    }

    public void readExternal(DataInput in) throws IOException {
        this.memberUID = new UID(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        this.memberUID.save(out);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.memberUID = new UID(reader.readString(0));
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(0, this.memberUID.toString());
    }
}

