/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command.commands;

import com.oracle.coherence.patterns.command.Command;
import com.oracle.coherence.patterns.command.Context;
import com.oracle.coherence.patterns.command.ExecutionEnvironment;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CommandBatch<C extends Context>
implements Command<C>,
ExternalizableLite,
PortableObject {
    private List<Command<C>> commands;

    public CommandBatch() {
    }

    public CommandBatch(List<Command<C>> commands) {
        this.commands = commands;
    }

    @Override
    public void execute(ExecutionEnvironment<C> executionEnvironment) {
        for (Command<C> command : this.commands) {
            command.execute(executionEnvironment);
        }
    }

    public void readExternal(DataInput in) throws IOException {
        int capacity = ExternalizableHelper.readInt((DataInput)in);
        if (capacity > 0) {
            this.commands = new ArrayList<Command<C>>(capacity);
            ExternalizableHelper.readCollection((DataInput)in, this.commands, (ClassLoader)this.getClass().getClassLoader());
        } else {
            this.commands = new ArrayList<Command<C>>();
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.commands.size());
        if (this.commands.size() > 0) {
            ExternalizableHelper.writeCollection((DataOutput)out, this.commands);
        }
    }

    public void readExternal(PofReader reader) throws IOException {
        int capacity = reader.readInt(0);
        if (capacity > 0) {
            this.commands = new ArrayList<Command<C>>(capacity);
            reader.readCollection(1, this.commands);
        } else {
            this.commands = new ArrayList<Command<C>>();
        }
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeInt(0, this.commands.size());
        if (this.commands.size() > 0) {
            writer.writeCollection(1, this.commands);
        }
    }

    public String toString() {
        return String.format("CommandBatch{commands=%s}", this.commands);
    }
}

