/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.identifiers.StringBasedIdentifier;
import com.oracle.coherence.common.identifiers.UUIDBasedIdentifier;
import com.oracle.coherence.patterns.command.Context;
import com.oracle.coherence.patterns.command.ContextConfiguration;
import com.oracle.coherence.patterns.command.ContextsManager;
import com.oracle.coherence.patterns.command.DefaultContextConfiguration;
import com.oracle.coherence.patterns.command.internal.CreateContextProcessor;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalProcessor;
import com.tangosol.util.processor.ExtractorProcessor;

public class DefaultContextsManager
implements ContextsManager {
    private static final ContextsManager INSTANCE = new DefaultContextsManager();

    @Override
    public Identifier registerContext(Identifier contextIdentifier, Context context, ContextConfiguration contextConfiguration) {
        NamedCache contextsCache = CacheFactory.getCache((String)"coherence.commandpattern.contexts");
        contextsCache.invoke((Object)contextIdentifier, (InvocableMap.EntryProcessor)new CreateContextProcessor(context, contextConfiguration));
        return contextIdentifier;
    }

    @Override
    public Identifier registerContext(Identifier contextIdentifier, Context context) {
        return this.registerContext(contextIdentifier, context, (ContextConfiguration)new DefaultContextConfiguration());
    }

    @Override
    public Identifier registerContext(String contextName, Context context, ContextConfiguration contextConfiguration) {
        return this.registerContext(StringBasedIdentifier.newInstance((String)contextName), context, contextConfiguration);
    }

    @Override
    public Identifier registerContext(String contextName, Context context) {
        return this.registerContext(contextName, context, (ContextConfiguration)new DefaultContextConfiguration());
    }

    @Override
    public Identifier registerContext(Context context, ContextConfiguration contextConfiguration) {
        return this.registerContext(UUIDBasedIdentifier.newInstance(), context, contextConfiguration);
    }

    @Override
    public Identifier registerContext(Context context) {
        return this.registerContext(context, new DefaultContextConfiguration());
    }

    @Override
    public Context getContext(Identifier identifier) {
        NamedCache contextsCache = CacheFactory.getCache((String)"coherence.commandpattern.contexts");
        return (Context)contextsCache.invoke((Object)identifier, (InvocableMap.EntryProcessor)new ExtractorProcessor("getContext"));
    }

    @Override
    public Object extractValueFromContext(Identifier identifier, ValueExtractor valueExtractor) {
        NamedCache contextsCache = CacheFactory.getCache((String)"coherence.commandpattern.contexts");
        return contextsCache.invoke((Object)identifier, (InvocableMap.EntryProcessor)new ConditionalProcessor((Filter)PresentFilter.INSTANCE, (InvocableMap.EntryProcessor)new ExtractorProcessor((ValueExtractor)new ChainedExtractor((ValueExtractor)new ReflectionExtractor("getContext"), valueExtractor))));
    }

    public static ContextsManager getInstance() {
        return INSTANCE;
    }
}

