/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command;

import com.oracle.coherence.patterns.command.ContextConfiguration;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DefaultContextConfiguration
implements ContextConfiguration,
ExternalizableLite,
PortableObject {
    private ContextConfiguration.ManagementStrategy managementStrategy;

    public DefaultContextConfiguration() {
        this.managementStrategy = ContextConfiguration.ManagementStrategy.DISTRIBUTED;
    }

    public DefaultContextConfiguration(ContextConfiguration.ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    @Override
    public ContextConfiguration.ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    public void readExternal(DataInput in) throws IOException {
        this.managementStrategy = ContextConfiguration.ManagementStrategy.values()[ExternalizableHelper.readInt((DataInput)in)];
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.managementStrategy.ordinal());
    }

    public void readExternal(PofReader reader) throws IOException {
        this.managementStrategy = ContextConfiguration.ManagementStrategy.values()[reader.readInt(0)];
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeInt(0, this.managementStrategy.ordinal());
    }

    public String toString() {
        return String.format("DefaultContextConfiguration{managementStrategy=%s}", new Object[]{this.managementStrategy});
    }
}

