/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.command;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.patterns.command.Command;
import com.oracle.coherence.patterns.command.CommandSubmitter;
import com.oracle.coherence.patterns.command.Context;
import com.oracle.coherence.patterns.command.ContextConfiguration;
import com.oracle.coherence.patterns.command.internal.CancelCommandProcessor;
import com.oracle.coherence.patterns.command.internal.CommandExecutionRequest;
import com.oracle.coherence.patterns.command.internal.SubmissionOutcome;
import com.oracle.coherence.patterns.command.internal.SubmitCommandExecutionRequestProcessor;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;

public class DefaultCommandSubmitter
implements CommandSubmitter {
    private static final CommandSubmitter INSTANCE = new DefaultCommandSubmitter();

    public DefaultCommandSubmitter() {
        CacheFactory.getCache((String)CommandExecutionRequest.getCacheName(ContextConfiguration.ManagementStrategy.DISTRIBUTED)).addIndex((ValueExtractor)new ReflectionExtractor("getContextIdentifier"), false, null);
        CacheFactory.getCache((String)CommandExecutionRequest.getCacheName(ContextConfiguration.ManagementStrategy.COLOCATED)).addIndex((ValueExtractor)new ReflectionExtractor("getContextIdentifier"), false, null);
    }

    @Override
    public <C extends Context> Identifier submitCommand(Identifier contextIdentifier, Command<C> command, boolean acceptCommandIfContextDoesNotExist) {
        CommandExecutionRequest commandExecutionRequest = new CommandExecutionRequest(contextIdentifier, command);
        NamedCache contextsCache = CacheFactory.getCache((String)"coherence.commandpattern.contexts");
        SubmissionOutcome submissionOutcome = (SubmissionOutcome)contextsCache.invoke((Object)contextIdentifier, (InvocableMap.EntryProcessor)new SubmitCommandExecutionRequestProcessor(commandExecutionRequest, acceptCommandIfContextDoesNotExist));
        if (submissionOutcome instanceof SubmissionOutcome.UnknownContext) {
            throw new IllegalArgumentException(String.format("Can't submit Command %s to Context %s as the Context does not exist", command, contextIdentifier));
        }
        return (SubmissionOutcome.Accepted)submissionOutcome;
    }

    @Override
    public <C extends Context> Identifier submitCommand(Identifier contextIdentifier, Command<C> command) {
        return this.submitCommand(contextIdentifier, command, false);
    }

    @Override
    public <C extends Context> boolean cancelCommand(Identifier commandIdentifier) {
        SubmissionOutcome.Accepted submissionOutcome = (SubmissionOutcome.Accepted)commandIdentifier;
        NamedCache commandsCache = CacheFactory.getCache((String)CommandExecutionRequest.getCacheName(submissionOutcome.getManagementStrategy()));
        Boolean result = (Boolean)commandsCache.invoke((Object)submissionOutcome.getCommandExecutionRequestKey(), (InvocableMap.EntryProcessor)new CancelCommandProcessor());
        return result;
    }

    public static CommandSubmitter getInstance() {
        return INSTANCE;
    }
}

