/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.region;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class CoherenceRegionValue
implements Serializable {
    private static final long serialVersionUID = 3748411110362855303L;
    private List<SoftLock> softLocks = new ArrayList<SoftLock>();
    private long timeOfSoftLockExpiration = 0L;
    private long timeOfSoftLockRelease = 0L;
    private long timestamp;
    private Object value;
    private Object version;

    public CoherenceRegionValue(Object value, Object version, long timestamp) {
        this.value = value;
        this.version = version;
        this.timestamp = timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object someObject) {
        if (this == someObject) {
            return true;
        }
        if (someObject == null || this.getClass() != someObject.getClass()) {
            return false;
        }
        CoherenceRegionValue value1 = (CoherenceRegionValue)someObject;
        if (this.timestamp != value1.timestamp) {
            return false;
        }
        if (!this.value.equals(value1.value)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(value1.version) : value1.version != null);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append("(value=").append(this.value);
        stringBuilder.append(", version=").append(this.version);
        stringBuilder.append(", timestamp=").append(this.timestamp);
        stringBuilder.append(", timeOfSoftLockExpiration=").append(this.timeOfSoftLockExpiration);
        stringBuilder.append(", timeOfSoftLockRelease=").append(this.timeOfSoftLockRelease);
        stringBuilder.append(", softLocks=(");
        for (SoftLock softLock : this.softLocks) {
            stringBuilder.append(softLock).append(", ");
        }
        if (this.softLocks.size() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    public void addSoftLock(SoftLock softLock) {
        this.softLocks.add(softLock);
        this.timeOfSoftLockExpiration = softLock.getExpirationTime();
    }

    public boolean isReplaceableFromLoad(long txTimestamp, Object replacementVersion, Comparator<Object> versionComparator) {
        return this.isSoftLocked() ? this.wereSoftLocksExpiredBefore(txTimestamp) : (this.version == null ? this.wereSoftLocksReleasedBefore(txTimestamp) : versionComparator.compare(this.version, replacementVersion) < 0);
    }

    public boolean isNotSoftLocked() {
        return !this.isSoftLocked();
    }

    public boolean isSoftLocked() {
        return this.softLocks.size() > 0;
    }

    public void releaseSoftLock(org.hibernate.cache.spi.access.SoftLock softLock, long timeOfRelease) {
        this.softLocks.remove(softLock);
        if (this.isNotSoftLocked()) {
            this.timeOfSoftLockRelease = timeOfRelease;
        }
    }

    private boolean wereSoftLocksExpiredBefore(long someTime) {
        return this.timeOfSoftLockExpiration < someTime;
    }

    private boolean wereSoftLocksReleasedBefore(long someTime) {
        return this.timeOfSoftLockRelease < someTime;
    }

    public static class SoftLock
    implements Serializable,
    org.hibernate.cache.spi.access.SoftLock {
        private static final long serialVersionUID = -1171771458206273933L;
        private UUID acquirerId;
        private long expirationTime;
        private long sequenceNumber;

        public SoftLock(UUID acquirerId, long sequenceNumber, long expirationTime) {
            this.acquirerId = acquirerId;
            this.expirationTime = expirationTime;
            this.sequenceNumber = sequenceNumber;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public boolean equals(Object someObject) {
            if (this == someObject) {
                return true;
            }
            if (someObject == null || this.getClass() != someObject.getClass()) {
                return false;
            }
            SoftLock softLock = (SoftLock)someObject;
            if (this.sequenceNumber != softLock.sequenceNumber) {
                return false;
            }
            return this.acquirerId.equals(softLock.acquirerId);
        }

        public int hashCode() {
            int result = this.acquirerId.hashCode();
            result = 31 * result + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
            return result;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
            stringBuilder.append("(acquirerId=").append(this.acquirerId);
            stringBuilder.append(", sequenceNumber=").append(this.sequenceNumber);
            stringBuilder.append(", expirationTime=").append(this.expirationTime);
            return stringBuilder.toString();
        }
    }
}

