/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.region;

import com.oracle.coherence.hibernate.cache.v6.configuration.support.Assert;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.processor.ConditionalPut;
import com.tangosol.util.processor.ConditionalRemove;
import com.tangosol.util.processor.ExtractorProcessor;
import java.util.Collection;
import java.util.Map;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceRegion
implements Region,
ExtendedStatisticsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoherenceRegion.class);
    private static final String PROPERTY_NAME_PREFIX = "com.oracle.coherence.hibernate.cache.";
    public static final String LOCK_LEASE_DURATION_PROPERTY_NAME = "com.oracle.coherence.hibernate.cache.lock_lease_duration";
    public static final int DEFAULT_LOCK_LEASE_DURATION = 60000;
    private final int lockLeaseDuration;
    private NamedCache namedCache;
    private final RegionFactory regionFactory;

    public CoherenceRegion(RegionFactory regionFactory, NamedCache namedCache, Map<String, Object> properties) {
        Assert.notNull(regionFactory, "regionFactory must not be null.");
        Assert.notNull(namedCache, "namedCache must not be null.");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Constructing CoherenceRegion for NamedCache '{}'.", (Object)namedCache.getCacheName());
        }
        this.lockLeaseDuration = (int)this.getDurationProperty(properties, LOCK_LEASE_DURATION_PROPERTY_NAME, 60000L, Integer.MAX_VALUE);
        this.namedCache = namedCache;
        this.regionFactory = regionFactory;
    }

    protected NamedCache getNamedCache() {
        return this.namedCache;
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append("(");
        stringBuilder.append(this.namedCache.getCacheName());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public long newSoftLockExpirationTime() {
        return this.nextTimestamp() + (long)this.getTimeout();
    }

    public Object getValue(Object key) {
        Object value = this.getNamedCache().get(key);
        return value != null ? value : null;
    }

    public void putValue(Object key, Object value) {
        this.getNamedCache().invoke(key, (InvocableMap.EntryProcessor)new ConditionalPut((Filter)AlwaysFilter.INSTANCE, value));
    }

    public void evict(Object key) {
        this.getNamedCache().invoke(key, (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)AlwaysFilter.INSTANCE));
    }

    public void evictAll() {
        this.getNamedCache().clear();
    }

    public void lockCache() {
        InvocableMapHelper.lockAll((ConcurrentMap)this.getNamedCache(), (Collection)this.getNamedCache().keySet(), (long)0L);
    }

    public void unlockCache() {
        InvocableMapHelper.unlockAll((ConcurrentMap)this.getNamedCache(), (Collection)this.getNamedCache().keySet());
    }

    public Object invoke(Object key, InvocableMap.EntryProcessor entryProcessor) {
        return this.getNamedCache().invoke(key, entryProcessor);
    }

    public String getName() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getName()");
        }
        return this.getNamedCache().getCacheName();
    }

    public void destroy() throws CacheException {
        if (!this.getNamedCache().isReleased()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("destroy()");
            }
            this.getNamedCache().release();
        }
    }

    public boolean contains(Object key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("contains({})", key);
        }
        return this.getNamedCache().invoke(key, (InvocableMap.EntryProcessor)new ExtractorProcessor((ValueExtractor)IdentityExtractor.INSTANCE)) != null;
    }

    public long getSizeInMemory() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getSizeInMemory()");
        }
        return -1L;
    }

    public long getElementCountInMemory() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getElementCountInMemory()");
        }
        return this.getNamedCache().size();
    }

    public long getElementCountOnDisk() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getElementCountOnDisk()");
        }
        return -1L;
    }

    public long nextTimestamp() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("nextTimestamp()");
        }
        return this.getRegionFactory().nextTimestamp();
    }

    public int getTimeout() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTimeout()");
        }
        return this.lockLeaseDuration;
    }

    protected long getDurationProperty(Map<String, Object> properties, String propertyName, long defaultValue, long maxValue) {
        long duration;
        Base.azzert((maxValue >= defaultValue ? 1 : 0) != 0);
        Base.azzert((defaultValue >= 0L ? 1 : 0) != 0);
        String propertyValue = (String)properties.get(propertyName);
        try {
            duration = Base.parseTime((String)propertyValue);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error parsing duration property {}; provided value was {}; using default of {} milliseconds.", new Object[]{propertyName, propertyValue, defaultValue});
            }
            duration = defaultValue;
        }
        if (duration > maxValue) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Capping {} at {} milliseconds.", (Object)propertyName, (Object)maxValue);
            }
            duration = maxValue;
        }
        return duration;
    }

    public void clear() {
        this.namedCache.clear();
    }
}

