/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.configuration.support;

import com.oracle.coherence.hibernate.cache.v6.configuration.support.Assert;
import com.tangosol.net.Session;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String WITH_NAME_CLASS_NAME = "com.tangosol.net.options.WithName";
    private static final String WITH_NAME_CLASS_OF_METHOD_NAME = "of";

    private ConfigUtils() {
        throw new AssertionError();
    }

    public static Session.Option getSessionNameOption(String sessionName) {
        Assert.notNull(sessionName, "The sessionName must not be null.");
        try {
            Class<?> withNameClass = Class.forName(WITH_NAME_CLASS_NAME);
            Method ofMethod = withNameClass.getMethod(WITH_NAME_CLASS_OF_METHOD_NAME, String.class);
            Session.Option sessionNameOption = (Session.Option)ofMethod.invoke(null, sessionName);
            return sessionNameOption;
        }
        catch (ClassNotFoundException ex) {
            String errorMessage = String.format("The required Class '%s' was not found. Most likely you are using a Coherence versionolder than '21.12' which does not support specifying a session name.", WITH_NAME_CLASS_NAME);
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(errorMessage);
            }
            throw new IllegalArgumentException(errorMessage, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(String.format("Method '%s' of class '%s' was not found.", WITH_NAME_CLASS_OF_METHOD_NAME, WITH_NAME_CLASS_NAME), ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(String.format("Executing the '%s' method of class '%s' threw an unexpected exception.", WITH_NAME_CLASS_OF_METHOD_NAME, WITH_NAME_CLASS_NAME), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(String.format("Method '%s' of class '%s' was not accessible.", WITH_NAME_CLASS_OF_METHOD_NAME, WITH_NAME_CLASS_NAME), ex);
        }
    }
}

