/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.configuration.support;

import com.oracle.coherence.hibernate.cache.v6.configuration.support.Assert;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceHibernateSystemPropertyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoherenceHibernateSystemPropertyResolver.class);
    private Map<String, Object> coherenceProperties = new ConcurrentHashMap<String, Object>(0);

    public CoherenceHibernateSystemPropertyResolver() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Constructing CoherenceHibernateSystemPropertyResolver.");
        }
    }

    public CoherenceHibernateSystemPropertyResolver(Map<String, Object> coherenceProperties) {
        this();
        Assert.notNull(coherenceProperties, "coherenceProperties must not be null.");
        this.coherenceProperties = coherenceProperties;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Providing the following coherenceProperties: {}", coherenceProperties);
        }
    }

    public String getProperty(String coherenceProperty) {
        Assert.notNull(coherenceProperty, "coherenceProperty must not be null.");
        if (this.coherenceProperties != null && !this.coherenceProperties.isEmpty()) {
            Object propertyValue = this.coherenceProperties.get(coherenceProperty);
            if (propertyValue == null) {
                return null;
            }
            if (propertyValue instanceof String) {
                return (String)propertyValue;
            }
            throw new IllegalStateException(String.format("Coherence property '%s' must be an instance of String.", coherenceProperty));
        }
        return null;
    }

    public void unset() {
        for (String propertyKey : this.coherenceProperties.keySet()) {
            System.clearProperty(propertyKey);
        }
    }

    public synchronized void addCoherenceProperty(String key, String value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding Coherence Property - key: {}, value: {}.", (Object)key, (Object)value);
        }
        this.coherenceProperties.put(key, value);
    }

    public void initialize() {
        for (String propertyKey : this.coherenceProperties.keySet()) {
            System.setProperty(propertyKey, this.getProperty(propertyKey));
        }
    }
}

