/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.configuration.support;

import com.oracle.coherence.hibernate.cache.v6.configuration.session.SessionType;
import com.oracle.coherence.hibernate.cache.v6.configuration.support.Assert;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CoherenceHibernateProperties {
    public static final String PROPERTY_NAME_PREFIX = "com.oracle.coherence.hibernate.cache.";
    public static final String CACHE_CONFIG_FILE_PATH_PROPERTY_NAME = "com.oracle.coherence.hibernate.cache.cache_config_file_path";
    public static final String CACHE_CONFIG_FILE_PATH_DEFAULT_VALUE = "hibernate-second-level-cache-config.xml";
    public static final String START_CACHE_SERVER_DEFAULT_VALUE = "false";
    public static final String COHERENCE_LOGGER_PROPERTY_NAME = "coherence.log";
    public static final String COHERENCE_LOGGER_DEFAULT_VALUE = "slf4j";
    public static final String COHERENCE_SESSION_NAME_PROPERTY_NAME = "com.oracle.coherence.hibernate.cache.session_name";
    public static final String COHERENCE_SESSION_TYPE_PROPERTY_NAME = "com.oracle.coherence.hibernate.cache.session_type";
    public static final String START_CACHE_SERVER_PROPERTY_NAME = "com.oracle.coherence.hibernate.cache.start_cache_server";
    public static final String DEFAULT_PROPERTY_PREFIX = "com.oracle.coherence.hibernate.cache.coherence_properties.";
    private final String cacheConfigFilePath;
    private final String sessionName;
    private final SessionType sessionType;
    private final boolean startCacheServer;
    private final Map<String, Object> coherenceProperties;

    public CoherenceHibernateProperties(Map hibernateProperties) {
        String startCacheServer;
        String sessionTypeAsString;
        String sessionName;
        String cacheConfigFilePath;
        this.coherenceProperties = this.getCoherenceSystemProperties(hibernateProperties);
        String string = cacheConfigFilePath = hibernateProperties != null ? (String)hibernateProperties.get(CACHE_CONFIG_FILE_PATH_PROPERTY_NAME) : null;
        if (cacheConfigFilePath == null) {
            cacheConfigFilePath = System.getProperty(CACHE_CONFIG_FILE_PATH_PROPERTY_NAME, CACHE_CONFIG_FILE_PATH_DEFAULT_VALUE);
        }
        this.cacheConfigFilePath = cacheConfigFilePath;
        String string2 = sessionName = hibernateProperties != null ? (String)hibernateProperties.get(COHERENCE_SESSION_NAME_PROPERTY_NAME) : null;
        if (sessionName == null) {
            sessionName = System.getProperty(COHERENCE_SESSION_NAME_PROPERTY_NAME, null);
        }
        this.sessionName = sessionName;
        String string3 = sessionTypeAsString = hibernateProperties != null ? (String)hibernateProperties.get(COHERENCE_SESSION_TYPE_PROPERTY_NAME) : null;
        if (sessionTypeAsString == null) {
            sessionTypeAsString = System.getProperty(COHERENCE_SESSION_TYPE_PROPERTY_NAME, null);
        }
        if (sessionTypeAsString != null) {
            Assert.hasText(sessionTypeAsString, "The sessionType cannot be an empty String.");
            this.sessionType = SessionType.valueOf(sessionTypeAsString.toUpperCase());
        } else {
            this.sessionType = null;
        }
        String string4 = startCacheServer = hibernateProperties != null ? (String)hibernateProperties.get(START_CACHE_SERVER_PROPERTY_NAME) : null;
        if (startCacheServer == null) {
            startCacheServer = System.getProperty(START_CACHE_SERVER_PROPERTY_NAME, START_CACHE_SERVER_DEFAULT_VALUE);
        }
        this.startCacheServer = Boolean.valueOf(startCacheServer);
    }

    public String getCacheConfigFilePath() {
        return this.cacheConfigFilePath;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public Map<String, Object> getCoherenceProperties() {
        return this.coherenceProperties;
    }

    public boolean isStartCacheServer() {
        return this.startCacheServer;
    }

    private Map<String, Object> getCoherenceSystemProperties(Map hibernateProperties) {
        ConcurrentHashMap<String, Object> resolvedCoherenceProperties = new ConcurrentHashMap<String, Object>(0);
        if (hibernateProperties != null) {
            Iterator iterator = hibernateProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry rawEntry;
                Map.Entry entry = rawEntry = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                Assert.notNull(key, "The key of the Hibernate property must not be null.");
                Assert.notNull(value, "The value of the Hibernate property must not be null.");
                if (!(key instanceof String)) {
                    throw new IllegalStateException("Map key should be a String.");
                }
                String keyAsString = (String)key;
                if (!keyAsString.startsWith(DEFAULT_PROPERTY_PREFIX)) continue;
                String keyWithoutPrefix = keyAsString.replace(DEFAULT_PROPERTY_PREFIX, "");
                if (value instanceof String) {
                    resolvedCoherenceProperties.put(keyWithoutPrefix, value);
                    continue;
                }
                throw new IllegalStateException(String.format("Coherence property '%s' must be an instance of String.", value));
            }
        }
        return resolvedCoherenceProperties;
    }
}

