/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access.processor;

import com.oracle.coherence.hibernate.cache.v6.region.CoherenceRegionValue;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.Serializable;
import java.util.Comparator;

public class ReadWritePutFromLoadProcessor
extends AbstractProcessor
implements Serializable {
    private static final long serialVersionUID = -3993308461928039511L;
    private boolean minimalPutsInEffect;
    private CoherenceRegionValue replacementValue;
    private long txTimestamp;
    private Comparator versionComparator;

    public ReadWritePutFromLoadProcessor(boolean minimalPutsInEffect, long txTimestamp, CoherenceRegionValue replacementValue, Comparator versionComparator) {
        this.minimalPutsInEffect = minimalPutsInEffect;
        this.txTimestamp = txTimestamp;
        this.replacementValue = replacementValue;
        this.versionComparator = versionComparator;
    }

    public Object process(InvocableMap.Entry entry) {
        boolean isReplaceable = true;
        if (entry.isPresent()) {
            if (this.minimalPutsInEffect) {
                return false;
            }
            CoherenceRegionValue presentValue = (CoherenceRegionValue)entry.getValue();
            isReplaceable = presentValue.isReplaceableFromLoad(this.txTimestamp, this.replacementValue.getVersion(), this.versionComparator);
        }
        if (isReplaceable) {
            entry.setValue((Object)this.replacementValue);
        }
        return isReplaceable;
    }
}

