/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access.processor;

import com.oracle.coherence.hibernate.cache.v6.region.CoherenceRegionValue;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.Serializable;
import org.hibernate.cache.spi.access.SoftLock;

public class AfterUpdateProcessor
extends AbstractProcessor
implements Serializable {
    private static final long serialVersionUID = 2890338818667968735L;
    private CoherenceRegionValue replacementValue;
    private SoftLock softLock;
    private long timeOfSoftLockRelease;

    public AfterUpdateProcessor(CoherenceRegionValue replacementValue, SoftLock softLock, long timeOfSoftLockRelease) {
        this.replacementValue = replacementValue;
        this.softLock = softLock;
        this.timeOfSoftLockRelease = timeOfSoftLockRelease;
    }

    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent()) {
            CoherenceRegionValue cacheValue = (CoherenceRegionValue)entry.getValue();
            cacheValue.releaseSoftLock(this.softLock, this.timeOfSoftLockRelease);
            if (cacheValue.isSoftLocked()) {
                entry.setValue((Object)cacheValue);
                return false;
            }
            entry.setValue((Object)this.replacementValue);
            return true;
        }
        return false;
    }
}

