/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access;

import com.oracle.coherence.hibernate.cache.v6.access.AbstractReadWriteCoherenceEntityDataAccess;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceReadWriteNaturalIdAccess
extends AbstractReadWriteCoherenceEntityDataAccess
implements NaturalIdDataAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoherenceReadWriteNaturalIdAccess.class);

    public CoherenceReadWriteNaturalIdAccess(DomainDataRegion domainDataRegion, DomainDataStorageAccess domainDataStorageAccess) {
        super(domainDataRegion, domainDataStorageAccess, null);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("insert - key: {}, value: {}", key, value);
        }
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("afterInsert({}, {})", key, value);
        }
        return this.afterInsert(key, this.newCacheValue(value, null));
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("update({}, {})", key, value);
        }
        return false;
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("afterUpdate({}, {}, {})", new Object[]{key, value, lock});
        }
        return this.afterUpdate(key, this.newCacheValue(value, null), lock);
    }

    public Object generateCacheKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return this.getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object getNaturalIdValues(Object cacheKey) {
        return this.getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }

    public AccessType getAccessType() {
        return AccessType.READ_WRITE;
    }

    @Override
    public boolean contains(Object key) {
        return false;
    }
}

